<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\User;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Group;
use function array_map;
trait UserGroupApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getGroups(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getGroups($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createGroup'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $userGroupId
     * @return Group
     * @throws HttpResponseException
     */
    public function getGroup(int $userGroupId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Group
    {
        $response = $this->getApiClient()->getGroup($userGroupId);
        return $this->createGroup($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Group
     */
    private function createGroup(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Group
    {
        /** @var Group $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Group::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
}
