<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\User\CustomFieldApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\User\UserApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\User\UserGroupApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
/**
 * Trait UserApis, includes all related ApiCalls pre and post processing related to Users
 * @package SupportPal\ApiClient\Api\Core
 */
class UserApi extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Api
{
    use CustomFieldApis;
    use UserApis;
    use UserGroupApis;
    /** @var UserApiClient */
    protected $apiClient;
    /**
     * @inheritDoc
     */
    protected function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient
    {
        return $this->apiClient;
    }
}
