<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\ApiClientAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use function sprintf;
trait AttachmentApis
{
    use ApiClientAware;
    /**
     * @param array<mixed> $queryParameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getAttachments(array $queryParameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_ATTACHMENT, $queryParameters);
    }
    /**
     * @param int $attachmentId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getAttachment(int $attachmentId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_ATTACHMENT . '/' . $attachmentId, []);
    }
    /**
     * @param int $attachmentId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function downloadAttachment(int $attachmentId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        $request = $this->getRequestFactory()->create('GET', \sprintf(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_ATTACHMENT_DOWNLOAD, $attachmentId));
        return $this->sendDownloadRequest($request);
    }
}
