<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\AttachmentApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\ChannelSettingsApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\CustomFieldApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\DepartmentApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\MessageApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\PriorityApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\SettingsApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Ticket\StatusApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
/**
 *  Contains all ApiClient calls to Tickets module
 * Trait TicketApis
 * @package SupportPal\ApiClient\ApiClient
 */
class TicketApiClient extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient
{
    use AttachmentApis;
    use ChannelSettingsApis;
    use CustomFieldApis;
    use DepartmentApis;
    use PriorityApis;
    use MessageApis;
    use SettingsApis;
    use StatusApis;
    /**
     * @param array<mixed> $queryParameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getTickets(array $queryParameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_TICKET, $queryParameters);
    }
    /**
     * @param int $ticketId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getTicket(int $ticketId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_TICKET . '/' . $ticketId, []);
    }
    /**
     * @param int $ticketId
     * @param array<mixed> $body
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function updateTicket(int $ticketId, array $body) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        $request = $this->getRequestFactory()->create('PUT', \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_TICKET . '/' . $ticketId, [], $body);
        return $this->sendRequest($request);
    }
    /**
     * @param array<mixed> $body
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function postTicket(array $body) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        $request = $this->getRequestFactory()->create('POST', \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_TICKET, [], $body);
        return $this->sendRequest($request);
    }
}
