<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\User\CustomFieldApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\User\UserGroupApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
/**
 * Trait UserApis, includes all api calls related to user apis
 * @package SupportPal\ApiClient\ApiClient\Core
 */
class UserApiClient extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient
{
    use CustomFieldApis;
    use UserGroupApis;
    /**
     * @param array<mixed> $queryParameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getUsers(array $queryParameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USER, $queryParameters);
    }
    /**
     * @param int $userId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getUser(int $userId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USER . '/' . $userId, []);
    }
    /**
     * @param int $userId
     * @param array<mixed> $body
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function updateUser(int $userId, array $body) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        $request = $this->getRequestFactory()->create('PUT', \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USER . '/' . $userId, [], $body);
        return $this->sendRequest($request);
    }
    /**
     * @param array<mixed> $body
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function postUser(array $body) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        $request = $this->getRequestFactory()->create('POST', \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USER, [], $body);
        return $this->sendRequest($request);
    }
}
