<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use function ltrim;
/**
 * This class includes the list of cachable apis related to their behaviour
 * Class ApiCacheMap
 * @package SupportPal\ApiClient\Cache
 */
class ApiCacheMap
{
    protected const DEFAULT_CACHE_TTL = 600;
    /**
     * Should not add duplicate entries in sub-arrays.
     * Duplicate entry will use the first occurring cache_ttl
     */
    protected const CACHE_MAP = [self::DEFAULT_CACHE_TTL => [\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::CORE_BRAND, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::CORE_SETTINGS, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_ARTICLE, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_ARTICLE_RELATED, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_ARTICLE_SEARCH, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_ARTICLE_TYPE, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_CATEGORY, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_SETTINGS, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_TAG, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_CHANNEL_SETTINGS, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_CUSTOMFIELD, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_DEPARTMENT, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_PRIORITY, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_SETTINGS, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::TICKET_STATUS, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_CUSTOMFIELD, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USERGROUP]];
    /**
     * @param string $baseUrl
     * @return array<int|string, array<int, string>>
     */
    public function getCacheableApis(string $baseUrl) : array
    {
        $cacheableApis = [];
        foreach (static::CACHE_MAP as $ttl => $apis) {
            $cacheableApis[$ttl] = [];
            foreach ($apis as $api) {
                $apiUri = $baseUrl . \ltrim($api, '/');
                $cacheableApis[$ttl][] = $apiUri;
            }
        }
        return $cacheableApis;
    }
}
