<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerInterface;
/**
 * This class handles the conversion of SupportPal Models to a <key, value> array
 * Class ModelToArrayConverter
 * @package SupportPal\ApiClient\Converter
 */
class ModelToArrayConverter
{
    /** @var SerializerInterface */
    private $serializer;
    /** @var DecoderInterface */
    private $decoder;
    /** @var string */
    private $format;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerInterface $serializer, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface $decoder, string $format)
    {
        $this->serializer = $serializer;
        $this->decoder = $decoder;
        $this->format = $format;
    }
    /**
     * @param Model $model
     * @throws UninitializedPropertyException
     * @return array<mixed>
     */
    public function convertOne(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model $model) : array
    {
        return $this->decoder->decode($this->serializer->serialize($model, $this->format), $this->format);
    }
}
