<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use Throwable;
/**
 * Class HttpResponseException
 * @package SupportPal\ApiClient\Exception
 */
class HttpResponseException extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\Exception
{
    /** @var RequestInterface */
    private $request;
    /** @var ResponseInterface|null */
    private $response;
    /**
     * HttpResponseException constructor.
     * @param RequestInterface $request
     * @param ResponseInterface|null $response
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, ?\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response = null, string $message = '', int $code = 0, ?\Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->request = $request;
        $this->response = $response;
    }
    /**
     * @return RequestInterface
     */
    public function getRequest() : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface
    {
        return $this->request;
    }
    /**
     * @return ResponseInterface|null
     */
    public function getResponse() : ?\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->response;
    }
}
