<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidDataException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerInterface;
/**
 * An abstract model factory that is the main base for all model factories
 * Class AbstractModelFactory
 * @package SupportPal\ApiClient\Factory
 */
abstract class BaseModelFactory implements \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\ModelFactory
{
    /** @var SerializerInterface */
    private $serializer;
    /** @var string */
    private $formatType;
    /** @var EncoderInterface */
    private $encoder;
    /**
     * AbstractModelFactory constructor.
     * @param SerializerInterface $serializer
     * @param string $formatType
     * @param EncoderInterface $encoder
     */
    public function __construct(string $formatType, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerInterface $serializer, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface $encoder)
    {
        $this->serializer = $serializer;
        $this->formatType = $formatType;
        $this->encoder = $encoder;
    }
    /**
     * @inheritDoc
     */
    public function create(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model
    {
        try {
            /** @var Model $model */
            $model = $this->serializer->deserialize($this->encoder->encode($data, $this->formatType), $this->getModel(), $this->formatType);
        } catch (\Exception $invalidArgumentException) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidDataException($data, $invalidArgumentException->getMessage(), $invalidArgumentException->getCode(), $invalidArgumentException);
        }
        return $model;
    }
}
