<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidDataException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
/**
 * Interface ModelFactory
 * @package SupportPal\ApiClient\Factory
 */
interface ModelFactory
{
    /**
     * This method creates an instance of a SupportPalModel
     * @param array<mixed> $data
     * @throws InvalidDataException
     * @return Model
     */
    public function create(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
    /**
     * This function returns the model name related to the relevant factory
     * @return string
     */
    public function getModel() : string;
}
