<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Core;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseTranslation;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class BrandTranslation extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseTranslation
{
    /**
     * @var int
     * @SerializedName("id")
     */
    private $id;
    /**
     * @var string
     * @SerializedName("name")
     */
    private $name;
    /**
     * @var int
     * @SerializedName("brand_id")
     */
    private $brandId;
    /**
     * @return int
     */
    public function getId() : int
    {
        return $this->id;
    }
    /**
     * @param int $id
     * @return $this
     */
    public function setId(int $id) : self
    {
        $this->id = $id;
        return $this;
    }
    /**
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * @param string $name
     * @return BrandTranslation
     */
    public function setName(string $name) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Core\BrandTranslation
    {
        $this->name = $name;
        return $this;
    }
    /**
     * @return int
     */
    public function getBrandId() : int
    {
        return $this->brandId;
    }
    /**
     * @param int $brandId
     * @return self
     */
    public function setBrandId(int $brandId) : self
    {
        $this->brandId = $brandId;
        return $this;
    }
}
