<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Request;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class CreateComment extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel
{
    public const REQUIRED_FIELDS = ['article_id', 'type_id', 'text'];
    /**
     * @var int
     * @SerializedName("article_id")
     */
    private $articleId;
    /**
     * @var int
     * @SerializedName("type_id")
     */
    private $typeId;
    /**
     * @var int|null
     * @SerializedName("parent_id")
     */
    private $parentId;
    /**
     * @var int|null
     * @SerializedName("author_id")
     */
    private $authorId;
    /**
     * @var string|null
     * @SerializedName("name")
     */
    private $name;
    /**
     * @var string
     * @SerializedName("text")
     */
    private $text;
    /**
     * @var int|null
     * @SerializedName("status")
     */
    private $status;
    /**
     * @var bool|null
     * @SerializedName("notify_reply")
     */
    private $notifyReply;
    /**
     * @return int
     */
    public function getArticleId() : int
    {
        return $this->articleId;
    }
    /**
     * @param int $articleId
     * @return self
     */
    public function setArticleId(int $articleId) : self
    {
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * @return int
     */
    public function getTypeId() : int
    {
        return $this->typeId;
    }
    /**
     * @param int $typeId
     * @return self
     */
    public function setTypeId(int $typeId) : self
    {
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * @return int|null
     */
    public function getParentId() : ?int
    {
        return $this->parentId;
    }
    /**
     * @param int|null $parentId
     * @return self
     */
    public function setParentId(?int $parentId) : self
    {
        $this->parentId = $parentId;
        return $this;
    }
    /**
     * @return int|null
     */
    public function getAuthorId() : ?int
    {
        return $this->authorId;
    }
    /**
     * @param int|null $authorId
     * @return self
     */
    public function setAuthorId(?int $authorId) : self
    {
        $this->authorId = $authorId;
        return $this;
    }
    /**
     * @return string|null
     */
    public function getName() : ?string
    {
        return $this->name;
    }
    /**
     * @param string|null $name
     * @return self
     */
    public function setName(?string $name) : self
    {
        $this->name = $name;
        return $this;
    }
    /**
     * @return string
     */
    public function getText() : string
    {
        return $this->text;
    }
    /**
     * @param string $text
     * @return self
     */
    public function setText(string $text) : self
    {
        $this->text = $text;
        return $this;
    }
    /**
     * @return int|null
     */
    public function getStatus() : ?int
    {
        return $this->status;
    }
    /**
     * @param int|null $status
     * @return self
     */
    public function setStatus(?int $status) : self
    {
        $this->status = $status;
        return $this;
    }
    /**
     * @return bool|null
     */
    public function getNotifyReply() : ?bool
    {
        return $this->notifyReply;
    }
    /**
     * @param bool|null $notifyReply
     * @return self
     */
    public function setNotifyReply(?bool $notifyReply) : self
    {
        $this->notifyReply = $notifyReply;
        return $this;
    }
}
