<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SettingsModel;
class Settings implements \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SettingsModel
{
    /** @var string[] */
    private $settings;
    /**
     * @inheritDoc
     */
    public function __set($property, $value)
    {
        $this->settings[$property] = $value;
    }
    /**
     * @inheritDoc
     */
    public function get(string $name, $default = null) : ?string
    {
        return $this->settings[$name] ?? $default;
    }
    /**
     * @inheritDoc
     */
    public function all() : array
    {
        return $this->settings;
    }
    /**
     * @inheritDoc
     */
    public function fill(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model
    {
        $this->settings = $data;
        return $this;
    }
}
