<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class Channel extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel
{
    /**
     * @var int
     * @SerializedName("updated_at")
     */
    private $updatedAt;
    /**
     * @var int
     * @SerializedName("created_at")
     */
    private $createdAt;
    /**
     * @var int
     * @SerializedName("id")
     */
    private $id;
    /**
     * @var string|null
     * @SerializedName("version")
     */
    private $version;
    /**
     * @var bool
     * @SerializedName("enabled")
     */
    private $enabled;
    /**
     * @var bool
     * @SerializedName("upgrade_available")
     */
    private $upgradeAvailable;
    /**
     * @var string
     * @SerializedName("name")
     */
    private $name;
    /**
     * @var string
     * @SerializedName("formatted_name")
     */
    private $formattedName;
    /**
     * @var bool|null
     * @SerializedName("show_on_frontend")
     */
    private $showOnFrontend;
    /**
     * @return int
     */
    public function getUpdatedAt() : int
    {
        return $this->updatedAt;
    }
    /**
     * @param int $updatedAt
     * @return self
     */
    public function setUpdatedAt(int $updatedAt) : self
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }
    /**
     * @return int
     */
    public function getCreatedAt() : int
    {
        return $this->createdAt;
    }
    /**
     * @param int $createdAt
     * @return self
     */
    public function setCreatedAt(int $createdAt) : self
    {
        $this->createdAt = $createdAt;
        return $this;
    }
    /**
     * @return int
     */
    public function getId() : int
    {
        return $this->id;
    }
    /**
     * @param int $id
     * @return self
     */
    public function setId(int $id) : self
    {
        $this->id = $id;
        return $this;
    }
    /**
     * @return string|null
     */
    public function getVersion() : ?string
    {
        return $this->version;
    }
    /**
     * @param string|null $version
     * @return self
     */
    public function setVersion(?string $version) : self
    {
        $this->version = $version;
        return $this;
    }
    /**
     * @return bool
     */
    public function getEnabled() : bool
    {
        return $this->enabled;
    }
    /**
     * @param bool $enabled
     * @return self
     */
    public function setEnabled(bool $enabled) : self
    {
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * @return bool
     */
    public function getUpgradeAvailable() : bool
    {
        return $this->upgradeAvailable;
    }
    /**
     * @param bool $upgradeAvailable
     * @return self
     */
    public function setUpgradeAvailable(bool $upgradeAvailable) : self
    {
        $this->upgradeAvailable = $upgradeAvailable;
        return $this;
    }
    /**
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->name = $name;
        return $this;
    }
    /**
     * @return string
     */
    public function getFormattedName() : string
    {
        return $this->formattedName;
    }
    /**
     * @param string $formattedName
     * @return self
     */
    public function setFormattedName(string $formattedName) : self
    {
        $this->formattedName = $formattedName;
        return $this;
    }
    /**
     * @return bool|null
     */
    public function getShowOnFrontend() : ?bool
    {
        return $this->showOnFrontend;
    }
    /**
     * @param bool $value
     * @return self
     */
    public function setShowOnFrontend(bool $value) : self
    {
        $this->showOnFrontend = $value;
        return $this;
    }
}
