<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Department\Department;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\CustomField;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class TicketCustomField extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\CustomField
{
    /**
     * @var int|null
     * @SerializedName("purge")
     */
    private $purge;
    /**
     * @var Department[]|null
     * @SerializedName("departments")
     */
    private $departments;
    /**
     * @var int|null
     * @SerializedName("ticket_id")
     */
    private $ticketId;
    /**
     * @var TicketCustomFieldTranslation[]|null
     * @SerializedName("translations")
     */
    private $translations;
    /**
     * @return int|null
     */
    public function getPurge() : ?int
    {
        return $this->purge;
    }
    /**
     * @param int|null $purge
     * @return self
     */
    public function setPurge(?int $purge) : self
    {
        $this->purge = $purge;
        return $this;
    }
    /**
     * @return Department[]|null
     */
    public function getDepartments() : ?array
    {
        return $this->departments;
    }
    /**
     * @param Department[]|null $departments
     * @return self
     */
    public function setDepartments(?array $departments) : self
    {
        $this->departments = $departments;
        return $this;
    }
    /**
     * @return int|null
     */
    public function getTicketId() : ?int
    {
        return $this->ticketId;
    }
    /**
     * @param int|null $ticketId
     * @return TicketCustomField
     */
    public function setTicketId(?int $ticketId) : self
    {
        $this->ticketId = $ticketId;
        return $this;
    }
    /**
     * @return TicketCustomFieldTranslation[]|null
     */
    public function getTranslations() : ?array
    {
        return $this->translations;
    }
    /**
     * @param TicketCustomFieldTranslation[]|null $translations
     * @return self
     */
    public function setTranslations(?array $translations) : self
    {
        $this->translations = $translations;
        return $this;
    }
}
