<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Normalizer;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Helper\StringHelper;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Transformer\AttributeAwareTransformer;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Transformer\Transformer;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\ContextAwareDenormalizerInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\ContextAwareNormalizerInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
class ModelNormalizer implements \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\ContextAwareNormalizerInterface, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\ContextAwareDenormalizerInterface
{
    use StringHelper;
    /** @var ObjectNormalizer */
    private $objectNormalizer;
    /** @var iterable|Transformer[] */
    private $transformers;
    /** @var iterable|AttributeAwareTransformer[] */
    private $attributeAwareTransformers;
    /**
     * ModelNormalizer constructor.
     * @param ObjectNormalizer $objectNormalizer
     * @param Transformer[] $transformers
     * @param AttributeAwareTransformer[] $attributeAwareTransformers
     */
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\ObjectNormalizer $objectNormalizer, iterable $transformers, iterable $attributeAwareTransformers)
    {
        $this->objectNormalizer = $objectNormalizer;
        $this->transformers = $transformers;
        $this->attributeAwareTransformers = $attributeAwareTransformers;
    }
    /**
     * @inheritDoc
     */
    public function normalize($object, ?string $format = null, array $context = [])
    {
        $data = $this->objectNormalizer->normalize($object, $format, $context);
        $data = $this->applyArrayTransformations($data);
        return $data;
    }
    /**
     * @inheritDoc
     */
    public function denormalize($data, string $type, ?string $format = null, array $context = [])
    {
        $data = $this->applyAttributeAwareTransformations($data, $type);
        /** @var Model $model */
        $model = $this->objectNormalizer->denormalize($data, $type, $format, $context);
        $model = $this->applyModelTransformations($model);
        return $model;
    }
    /**
     * @inheritDoc
     */
    public function supportsNormalization($data, ?string $format = null, array $context = []) : bool
    {
        return $data instanceof \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model || $this->objectNormalizer->supportsNormalization($data, $format);
    }
    /**
     * @inheritDoc
     */
    public function supportsDenormalization($data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $this->objectNormalizer->supportsDenormalization($data, $type, $format);
    }
    /**
     * @param Model $model
     * @return Model
     */
    protected function applyModelTransformations(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model $model)
    {
        foreach ($this->transformers as $transformer) {
            if (!$transformer->canTransform($model)) {
                continue;
            }
            $model = $transformer->transform($model);
        }
        return $model;
    }
    /**
     * @param array<mixed> $data
     * @param string $type
     * @return array<mixed>
     */
    protected function applyAttributeAwareTransformations(array $data, string $type) : array
    {
        foreach ($data as $key => $value) {
            foreach ($this->attributeAwareTransformers as $transformer) {
                if (!$transformer->canTransform($this->snakeCaseToCamelCase($key), $type, $value)) {
                    continue;
                }
                $data[$key] = $transformer->transform($value);
            }
        }
        return $data;
    }
    /**
     * @param array<mixed> $data
     * @return array<mixed>
     */
    protected function applyArrayTransformations(array $data) : array
    {
        foreach ($data as $key => $value) {
            foreach ($this->transformers as $transformer) {
                if (!$transformer->canTransform($value)) {
                    continue;
                }
                $data[$key] = $transformer->transform($value);
            }
        }
        return $data;
    }
}
