<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session;

use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\RequestStack;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session\Storage\SessionStorageFactoryInterface;
// Help opcache.preload discover always-needed symbols
\class_exists(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session\Session::class);
/**
 * @author Jérémy Derussé <jeremy@derusse.com>
 */
class SessionFactory implements \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session\SessionFactoryInterface
{
    private $requestStack;
    private $storageFactory;
    private $usageReporter;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\RequestStack $requestStack, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session\Storage\SessionStorageFactoryInterface $storageFactory, callable $usageReporter = null)
    {
        $this->requestStack = $requestStack;
        $this->storageFactory = $storageFactory;
        $this->usageReporter = $usageReporter;
    }
    public function createSession() : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session\SessionInterface
    {
        return new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Session\Session($this->storageFactory->createStorage($this->requestStack->getMainRequest()), null, null, $this->usageReporter);
    }
}
