<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder;

use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\RuntimeException;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Dumper;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Parser;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Yaml;
/**
 * Encodes YAML data.
 *
 * @author Kévin Dunglas <dunglas@gmail.com>
 */
class YamlEncoder implements \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface
{
    public const FORMAT = 'yaml';
    private const ALTERNATIVE_FORMAT = 'yml';
    public const PRESERVE_EMPTY_OBJECTS = 'preserve_empty_objects';
    public const YAML_INLINE = 'yaml_inline';
    public const YAML_INDENT = 'yaml_indent';
    public const YAML_FLAGS = 'yaml_flags';
    private $dumper;
    private $parser;
    private $defaultContext = [self::YAML_INLINE => 0, self::YAML_INDENT => 0, self::YAML_FLAGS => 0];
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Dumper $dumper = null, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Parser $parser = null, array $defaultContext = [])
    {
        if (!\class_exists(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Dumper::class)) {
            throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\RuntimeException('The YamlEncoder class requires the "Yaml" component. Install "symfony/yaml" to use it.');
        }
        $this->dumper = $dumper ?? new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Dumper();
        $this->parser = $parser ?? new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Parser();
        $this->defaultContext = \array_merge($this->defaultContext, $defaultContext);
    }
    /**
     * {@inheritdoc}
     */
    public function encode($data, string $format, array $context = [])
    {
        $context = \array_merge($this->defaultContext, $context);
        if (isset($context[self::PRESERVE_EMPTY_OBJECTS])) {
            $context[self::YAML_FLAGS] |= \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Yaml\Yaml::DUMP_OBJECT_AS_MAP;
        }
        return $this->dumper->dump($data, $context[self::YAML_INLINE], $context[self::YAML_INDENT], $context[self::YAML_FLAGS]);
    }
    /**
     * {@inheritdoc}
     */
    public function supportsEncoding(string $format)
    {
        return self::FORMAT === $format || self::ALTERNATIVE_FORMAT === $format;
    }
    /**
     * {@inheritdoc}
     */
    public function decode(string $data, string $format, array $context = [])
    {
        $context = \array_merge($this->defaultContext, $context);
        return $this->parser->parse($data, $context[self::YAML_FLAGS]);
    }
    /**
     * {@inheritdoc}
     */
    public function supportsDecoding(string $format)
    {
        return self::FORMAT === $format || self::ALTERNATIVE_FORMAT === $format;
    }
}
