<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\Loader;

use SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Annotations\Reader;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Context;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\DiscriminatorMap;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Groups;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Ignore;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\MaxDepth;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\MappingException;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\AttributeMetadata;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\AttributeMetadataInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\ClassDiscriminatorMapping;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\ClassMetadataInterface;
/**
 * Loader for Doctrine annotations and PHP 8 attributes.
 *
 * @author Kévin Dunglas <dunglas@gmail.com>
 * @author Alexander M. Turek <me@derrabus.de>
 */
class AnnotationLoader implements \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\Loader\LoaderInterface
{
    private const KNOWN_ANNOTATIONS = [\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\DiscriminatorMap::class, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Groups::class, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Ignore::class, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\MaxDepth::class, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName::class, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Context::class];
    private $reader;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Annotations\Reader $reader = null)
    {
        $this->reader = $reader;
    }
    /**
     * {@inheritdoc}
     */
    public function loadClassMetadata(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\ClassMetadataInterface $classMetadata)
    {
        $reflectionClass = $classMetadata->getReflectionClass();
        $className = $reflectionClass->name;
        $loaded = \false;
        $attributesMetadata = $classMetadata->getAttributesMetadata();
        foreach ($this->loadAnnotations($reflectionClass) as $annotation) {
            if ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\DiscriminatorMap) {
                $classMetadata->setClassDiscriminatorMapping(new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\ClassDiscriminatorMapping($annotation->getTypeProperty(), $annotation->getMapping()));
            }
        }
        foreach ($reflectionClass->getProperties() as $property) {
            if (!isset($attributesMetadata[$property->name])) {
                $attributesMetadata[$property->name] = new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\AttributeMetadata($property->name);
                $classMetadata->addAttributeMetadata($attributesMetadata[$property->name]);
            }
            if ($property->getDeclaringClass()->name === $className) {
                foreach ($this->loadAnnotations($property) as $annotation) {
                    if ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Groups) {
                        foreach ($annotation->getGroups() as $group) {
                            $attributesMetadata[$property->name]->addGroup($group);
                        }
                    } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\MaxDepth) {
                        $attributesMetadata[$property->name]->setMaxDepth($annotation->getMaxDepth());
                    } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName) {
                        $attributesMetadata[$property->name]->setSerializedName($annotation->getSerializedName());
                    } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Ignore) {
                        $attributesMetadata[$property->name]->setIgnore(\true);
                    } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Context) {
                        $this->setAttributeContextsForGroups($annotation, $attributesMetadata[$property->name]);
                    }
                    $loaded = \true;
                }
            }
        }
        foreach ($reflectionClass->getMethods() as $method) {
            if ($method->getDeclaringClass()->name !== $className) {
                continue;
            }
            if (0 === \stripos($method->name, 'get') && $method->getNumberOfRequiredParameters()) {
                continue;
                /*  matches the BC behavior in `Symfony\Component\Serializer\Normalizer\ObjectNormalizer::extractAttributes` */
            }
            $accessorOrMutator = \preg_match('/^(get|is|has|set)(.+)$/i', $method->name, $matches);
            if ($accessorOrMutator) {
                $attributeName = \lcfirst($matches[2]);
                if (isset($attributesMetadata[$attributeName])) {
                    $attributeMetadata = $attributesMetadata[$attributeName];
                } else {
                    $attributesMetadata[$attributeName] = $attributeMetadata = new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\AttributeMetadata($attributeName);
                    $classMetadata->addAttributeMetadata($attributeMetadata);
                }
            }
            foreach ($this->loadAnnotations($method) as $annotation) {
                if ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Groups) {
                    if (!$accessorOrMutator) {
                        throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\MappingException(\sprintf('Groups on "%s::%s()" cannot be added. Groups can only be added on methods beginning with "get", "is", "has" or "set".', $className, $method->name));
                    }
                    foreach ($annotation->getGroups() as $group) {
                        $attributeMetadata->addGroup($group);
                    }
                } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\MaxDepth) {
                    if (!$accessorOrMutator) {
                        throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\MappingException(\sprintf('MaxDepth on "%s::%s()" cannot be added. MaxDepth can only be added on methods beginning with "get", "is", "has" or "set".', $className, $method->name));
                    }
                    $attributeMetadata->setMaxDepth($annotation->getMaxDepth());
                } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName) {
                    if (!$accessorOrMutator) {
                        throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\MappingException(\sprintf('SerializedName on "%s::%s()" cannot be added. SerializedName can only be added on methods beginning with "get", "is", "has" or "set".', $className, $method->name));
                    }
                    $attributeMetadata->setSerializedName($annotation->getSerializedName());
                } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Ignore) {
                    if (!$accessorOrMutator) {
                        throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\MappingException(\sprintf('Ignore on "%s::%s()" cannot be added. Ignore can only be added on methods beginning with "get", "is", "has" or "set".', $className, $method->name));
                    }
                    $attributeMetadata->setIgnore(\true);
                } elseif ($annotation instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Context) {
                    if (!$accessorOrMutator) {
                        throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\MappingException(\sprintf('Context on "%s::%s()" cannot be added. Context can only be added on methods beginning with "get", "is", "has" or "set".', $className, $method->name));
                    }
                    $this->setAttributeContextsForGroups($annotation, $attributeMetadata);
                }
                $loaded = \true;
            }
        }
        return $loaded;
    }
    /**
     * @param \ReflectionClass|\ReflectionMethod|\ReflectionProperty $reflector
     */
    public function loadAnnotations(object $reflector) : iterable
    {
        if (\PHP_VERSION_ID >= 80000) {
            foreach ($reflector->getAttributes() as $attribute) {
                if ($this->isKnownAttribute($attribute->getName())) {
                    (yield $attribute->newInstance());
                }
            }
        }
        if (null === $this->reader) {
            return;
        }
        if ($reflector instanceof \ReflectionClass) {
            yield from $this->reader->getClassAnnotations($reflector);
        }
        if ($reflector instanceof \ReflectionMethod) {
            yield from $this->reader->getMethodAnnotations($reflector);
        }
        if ($reflector instanceof \ReflectionProperty) {
            yield from $this->reader->getPropertyAnnotations($reflector);
        }
    }
    private function setAttributeContextsForGroups(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\Context $annotation, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Mapping\AttributeMetadataInterface $attributeMetadata) : void
    {
        if ($annotation->getContext()) {
            $attributeMetadata->setNormalizationContextForGroups($annotation->getContext(), $annotation->getGroups());
            $attributeMetadata->setDenormalizationContextForGroups($annotation->getContext(), $annotation->getGroups());
        }
        if ($annotation->getNormalizationContext()) {
            $attributeMetadata->setNormalizationContextForGroups($annotation->getNormalizationContext(), $annotation->getGroups());
        }
        if ($annotation->getDenormalizationContext()) {
            $attributeMetadata->setDenormalizationContextForGroups($annotation->getDenormalizationContext(), $annotation->getGroups());
        }
    }
    private function isKnownAttribute(string $attributeName) : bool
    {
        foreach (self::KNOWN_ANNOTATIONS as $knownAnnotation) {
            if (\is_a($attributeName, $knownAnnotation, \true)) {
                return \true;
            }
        }
        return \false;
    }
}
