<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer;

use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Address;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\HeaderInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\UnstructuredHeader;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Message;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Part\AbstractPart;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerAwareInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerInterface;
/**
 * Normalize Mime message classes.
 *
 * It forces the use of a PropertyNormalizer instance for normalization
 * of all data objects composing a Message.
 *
 * Emails using resources for any parts are not serializable.
 */
final class MimeMessageNormalizer implements \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\NormalizerInterface, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\DenormalizerInterface, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerAwareInterface, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\CacheableSupportsMethodInterface
{
    private $serializer;
    private $normalizer;
    private $headerClassMap;
    private $headersProperty;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\PropertyNormalizer $normalizer)
    {
        $this->normalizer = $normalizer;
        $this->headerClassMap = (new \ReflectionClassConstant(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers::class, 'HEADER_CLASS_MAP'))->getValue();
        $this->headersProperty = new \ReflectionProperty(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers::class, 'headers');
        $this->headersProperty->setAccessible(\true);
    }
    public function setSerializer(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\SerializerInterface $serializer)
    {
        $this->serializer = $serializer;
        $this->normalizer->setSerializer($serializer);
    }
    /**
     * {@inheritdoc}
     */
    public function normalize($object, string $format = null, array $context = [])
    {
        if ($object instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers) {
            $ret = [];
            foreach ($this->headersProperty->getValue($object) as $name => $header) {
                $ret[$name] = $this->serializer->normalize($header, $format, $context);
            }
            return $ret;
        }
        if ($object instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Part\AbstractPart) {
            $ret = $this->normalizer->normalize($object, $format, $context);
            $ret['class'] = \get_class($object);
            unset($ret['seekable'], $ret['cid'], $ret['handle']);
            return $ret;
        }
        return $this->normalizer->normalize($object, $format, $context);
    }
    /**
     * {@inheritdoc}
     */
    public function denormalize($data, string $type, string $format = null, array $context = [])
    {
        if (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers::class === $type) {
            $ret = [];
            foreach ($data as $headers) {
                foreach ($headers as $header) {
                    $ret[] = $this->serializer->denormalize($header, $this->headerClassMap[\strtolower($header['name'])] ?? \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\UnstructuredHeader::class, $format, $context);
                }
            }
            return new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers(...$ret);
        }
        if (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Part\AbstractPart::class === $type) {
            $type = $data['class'];
            unset($data['class']);
        }
        return $this->normalizer->denormalize($data, $type, $format, $context);
    }
    /**
     * {@inheritdoc}
     */
    public function supportsNormalization($data, string $format = null) : bool
    {
        return $data instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Message || $data instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers || $data instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\HeaderInterface || $data instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Address || $data instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Part\AbstractPart;
    }
    /**
     * {@inheritdoc}
     */
    public function supportsDenormalization($data, string $type, string $format = null) : bool
    {
        return \is_a($type, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Message::class, \true) || \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Header\Headers::class === $type || \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Mime\Part\AbstractPart::class === $type;
    }
    /**
     * {@inheritdoc}
     */
    public function hasCacheableSupportsMethod() : bool
    {
        return __CLASS__ === static::class;
    }
}
