<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer;

use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\ErrorHandler\Exception\FlattenException;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\InvalidArgumentException;
/**
 * Normalizes errors according to the API Problem spec (RFC 7807).
 *
 * @see https://tools.ietf.org/html/rfc7807
 *
 * @author Kévin Dunglas <dunglas@gmail.com>
 * @author Yonel Ceruto <yonelceruto@gmail.com>
 */
class ProblemNormalizer implements \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\NormalizerInterface, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\CacheableSupportsMethodInterface
{
    private $debug;
    private $defaultContext = ['type' => 'https://tools.ietf.org/html/rfc2616#section-10', 'title' => 'An error occurred'];
    public function __construct(bool $debug = \false, array $defaultContext = [])
    {
        $this->debug = $debug;
        $this->defaultContext = $defaultContext + $this->defaultContext;
    }
    /**
     * {@inheritdoc}
     *
     * @return array
     */
    public function normalize($object, string $format = null, array $context = [])
    {
        if (!$object instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\ErrorHandler\Exception\FlattenException) {
            throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\InvalidArgumentException(\sprintf('The object must implement "%s".', \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\ErrorHandler\Exception\FlattenException::class));
        }
        $context += $this->defaultContext;
        $debug = $this->debug && ($context['debug'] ?? \true);
        $data = ['type' => $context['type'], 'title' => $context['title'], 'status' => $context['status'] ?? $object->getStatusCode(), 'detail' => $debug ? $object->getMessage() : $object->getStatusText()];
        if ($debug) {
            $data['class'] = $object->getClass();
            $data['trace'] = $object->getTrace();
        }
        return $data;
    }
    /**
     * {@inheritdoc}
     */
    public function supportsNormalization($data, string $format = null) : bool
    {
        return $data instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\ErrorHandler\Exception\FlattenException;
    }
    /**
     * {@inheritdoc}
     */
    public function hasCacheableSupportsMethod() : bool
    {
        return \true;
    }
}
