{if $categories|@count}

    <h3>{$LANG2.categories}</h3>

    <div class="row">
        {section name=cat loop=$categories}
            <div class="col-sm-6">
                <div class="card w-100">
                    <a class="card-header" href="?category={$categories[cat].id|escape}-{$categories[cat].slug|escape}">
                        <p class="h5 mb-0">
                            <span class="fas fa fa-folder"></span>&nbsp;
                            <strong>{$categories[cat].name|escape}</strong>
                            {if $categories[cat].count > 0}
                                &nbsp;<span class="badge badge-info">{$categories[cat].count|escape}</span>
                            {/if}
                        </p>
                    </a>

                    <ul class="list-group list-group-flush">
                        {section name=item loop=$categories[cat].articles max=3}
                            <li class="list-group-item">
                                <a href="?id={$categories[cat].articles[item].id|escape}-{$categories[cat].articles[item].slug|escape}">
                                    <i class="fa fas fa-{$icon_name}"></i>&nbsp;
                                    {$categories[cat].articles[item].title|escape}
                                </a>
                            </li>
                        {sectionelse}
                            <li class="list-group-item">{$LANG2.knowledgebase_none}</li>
                        {/section}
                        {if $categories[cat].count > 3}
                            <li class="list-group-item small">
                                <a class="text-muted" href="?category={$categories[cat].id|escape}-{$categories[cat].slug|escape}">{$LANG2.knowledgebase_viewall} &raquo;</a>
                            </li>
                        {/if}
                    </ul>
                </div>
            </div>
        {/section}
    </div>

{/if}
