<!-- Comments Section -->
{if $settings.comments_enabled}
    <div {if !$data.comments|@count}class="hidden-print d-print-none"{/if}>
        <hr />

        {if isset($comment_status) && $comment_status == 1}
            {include file="$template/includes/alert.tpl" type="success" textcenter=true hide=false additionalClasses="comment-status" msg=$LANG2.comments_success}
        {elseif isset($comment_status) && $comment_status == 0}
            {include file="$template/includes/alert.tpl" type="success" textcenter=true hide=false additionalClasses="comment-status" msg=$LANG2.comments_accepted_for_moderation}
        {elseif isset($comment_status) && $comment_status == -1}
            {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false additionalClasses="comment-status" msg=$LANG2.tickets_captchaError}
        {elseif isset($comment_status) && $comment_status == -2}
            {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false additionalClasses="comment-status" msg=$LANG.genericerror.title}
        {/if}

        <h3>{$LANG2.comments}</h3>
    </div>

    {if $settings.comment_write == '1' && !$userLoggedIn}
        <a href="clientarea.php">{$LANG2.comments_login_to_comment}</a>
        <br /><br />
    {else}
        <div class="sp-add-comment panel panel-info panel-collapsable {if !isset($orig_comment_message)}panel-collapsed{/if} card hidden-print d-print-none">
            <div class="panel-heading card-header" data-toggle="collapse" data-target="#sp-add-comment" style="cursor: pointer;">
                <div class="collapse-icon pull-right float-right">
                    <i class="fa fas fa-plus"></i>
                </div>
                <p class="panel-title mb-0">
                    <strong>
                        <i class="fa fas fa-fw fa-comment"></i> &nbsp; {$LANG2.comments_add}
                    </strong>
                </p>
            </div>

            <div class="panel-body {if !isset($orig_comment_message)}panel-body-collapsed{else}in show{/if} card-body collapse" id="sp-add-comment">
                <div id="replyDiv" style="display: none;"><strong>{$LANG2.comments_replying_to}:</strong> <span id="replySpan"></span>&nbsp;
                    <input class="btn btn-default btn-sm sp-cancel-comment" type="button" value="{$LANG2.button_cancel}" /><br /><br />
                </div>

                <form name="myForm" id="post-comment-form" method="POST" action="">
                    <input type="hidden" name="comment_parent_id" />

                    {if !$helpdeskUser}
                        <div class="row">
                            <div class="form-group col-sm-12">
                                <label>{$LANG.supportticketsclientname}</label>
                                <input type="text" name="comment_name" value="{$orig_comment_name|escape}" class="form-control" />
                            </div>
                        </div>
                    {else}
                        <input type="hidden" name="comment_name" value="N/A" />
                    {/if}
                    <div class="form-group">
                        <label>{$LANG.contactmessage}</label>
                        <textarea name="comment_message" rows="5" class="form-control">{$orig_comment_message|escape}</textarea>
                    </div>

                    {if $helpdeskUser}
                        <div class="row">
                            <div class="form-group col-sm-12">
                                <label>
                                    <input type="checkbox" name="comment_email_author" {if $orig_comment_email_author == 'on'}checked="checked"{/if} />&nbsp;
                                    {$LANG2.comments_send_email}
                                </label>
                            </div>
                        </div>
                    {/if}

                    {include file='templates/supportpal/recaptcha.tpl'}

                    <input type="submit" value="{$LANG.supportticketsticketsubmit}" class="btn btn-primary" />
                </form>
            </div>
        </div>
    {/if}

    {if $data.comments|@count}
        <div class="card">
            {section name=c loop=$data.comments}
                <div class="comment clearfix" {if !empty($data.comments[c].root_parent_id)}style="margin-left: 2rem"{/if}>

                    <a name="comment-{$data.comments[c].id}"></a>

                    <a class="btn btn-default btn-sm commentreply sp-reply-comment pull-right float-right hidden-print d-print-none"
                       data-id="{$data.comments[c].id|escape}"
                       data-author-name="{$data.comments[c].author.formatted_name|escape}"
                       style="cursor: pointer;">
                        {$LANG2.comments_reply}
                    </a>

                    <div class="card-header {if $data.comments[c].author.role == 1}bg-primary{else}bg-dark{/if} text-white">
                        {if !empty($data.comments[c].root_parent_id)}
                            <i class="fa fas fa-level-up fa-rotate-90"></i>
                        {/if}
                        <strong>{$data.comments[c].author.formatted_name|escape}</strong> &nbsp;
                        <span class="small text-light">{$data.comments[c].created_at|escape}</span>
                    </div>

                    <div class="card-body">{$data.comments[c].purified_text}</div>
                </div>
            {/section}
        </div>
    {/if}
{/if}
