<link rel="stylesheet" type="text/css" media="screen" href="templates/supportpal/css/main.css" />
<link rel="stylesheet" type="text/css" media="screen" href="templates/supportpal/dist/viewticket.css" />

{if $ticketError}
    {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG.supportticketinvalid}
{else}
    <h2>#{$data.number|escape} - {$data.subject|escape}</h2>

    {if $smarty.get.reply_posted == '1'}
        {include file="$template/includes/alert.tpl" type="success" textcenter=true hide=false msg=$LANG2.reply_posted}
    {elseif $smarty.get.reply_posted == '0'}
        {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG2.reply_posted_error}
    {/if}

    {if $smarty.get.saved_fields == '1'}
        {include file="$template/includes/alert.tpl" type="success" textcenter=true hide=false msg=$LANG2.fields_saved}
    {elseif $smarty.get.saved_fields == '0'}
        {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG2.fields_saved_error}
    {/if}

    {if $smarty.get.user_closed == '1'}
        {include file="$template/includes/alert.tpl" type="success" textcenter=true hide=false msg=$LANG2.user_closed}
    {elseif $smarty.get.user_closed == '0'}
        {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG2.user_closed_error}
    {elseif $data.status.id == $settings.default_resolved_status && $data.locked == 0}
        <!-- Closed ticket -->
        {include file="$template/includes/alert.tpl" type="success" textcenter=true hide=false msg=$LANG.supportticketclosedmsg}
    {elseif $data.locked == 1}
        <!-- Locked ticket -->
        {include file="$template/includes/alert.tpl" type="warning" textcenter=true hide=false msg=$LANG2.tickets_locked}
    {else}
        <!-- Button to close ticket -->
        <p>
            <a href="?number={$data.number|escape}&amp;token={$data.token|escape}&amp;close=1" class="btn btn-default">
                {$LANG.supportticketsstatuscloseticket}
            </a>
        </p>
    {/if}

    <div class="table-container clearfix">
        <div class="dataTables_wrapper form-inline dt-bootstrap dt-bootstrap4 no-footer">
            <div class="w-100" style="overflow-x: auto;">
                <table class="table table-list dataTable no-footer dtr-inline text-nowrap">
                    <tr>
                        <th style="text-align: center">{$LANG.supportticketsdepartment}</th>
                        <th style="text-align: center">{$LANG.supportticketsstatus}</th>
                        <th style="text-align: center">{$LANG.supportticketsticketurgency}</th>
                        <th style="text-align: center">{$LANG.supportticketsubmitted}</th>
                        <th style="text-align: center">{$LANG.supportticketsticketlastupdated}</th>
                    </tr>
                    <tr>
                        <td align="center">{$data.department.name|escape}</td>
                        <td align="center">
                            {if $data.status.colour}<span style="color: {$data.status.colour|escape};">{/if}
                            {$data.status.name|escape}
                            {if $data.status.colour}</span>{/if}
                        </td>
                        <td align="center">
                            {if $data.priority.colour}<span style="color: {$data.priority.colour|escape};">{/if}
                            {$data.priority.name|escape}
                            {if $data.priority.colour}</span>{/if}
                        </td>
                        <td align="center">{$data.created_at|escape}</td>
                        <td align="center">{$data.updated_at|escape}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    {if $customfields|@count > 0}
        <div class="panel panel-info panel-collapsable panel-collapsed card hidden-print d-print-none">
            <div class="panel-heading card-header" data-toggle="collapse" data-target="#sp-custom-fields" style="cursor: pointer;">
                <div class="collapse-icon pull-right float-right">
                    <i class="fa fas fa-plus"></i>
                </div>
                <p class="panel-title mb-0">
                    <strong>
                        <i class="fa fas fa-fw fa-info"></i> &nbsp; {$LANG2.tickets_fields}
                    </strong>
                </p>
            </div>
            <div class="panel-body panel-body-collapsed card-body collapse" id="sp-custom-fields">
                {if $data.status.id != $settings.default_resolved_status && $data.locked == 0}
                    <form name="tcf" id="tcf" method="POST">
                {/if}

                {include file='templates/supportpal/customfields.tpl'}

                {if $data.status.id != $settings.default_resolved_status && $data.locked == 0}
                        <input type="hidden" name="update_fields" value="1" />
                        <input type="submit" value="{$LANG2.button_save_fields}" class="btn btn-primary" />
                    </form>
                {/if}
            </div>
        </div>
    {/if}

    {if !$data.locked}
        <div class="panel panel-info panel-collapsable{if !$postingReply && $data.status.id == $settings.default_resolved_status} panel-collapsed{/if} card hidden-print d-print-none">
            <div class="panel-heading card-header" data-toggle="collapse" data-target="#sp-reply-form" id="ticketReply" style="cursor: pointer;">
                <div class="collapse-icon pull-right float-right">
                    <i class="fa fas fa-{if !$postingReply && $data.status.id == $settings.default_resolved_status}plus{else}minus{/if}"></i>
                </div>
                <p class="panel-title mb-0">
                    <strong>
                        <i class="fa fas fa-fw fa-pencil"></i> &nbsp; {$LANG.supportticketsreply}
                    </strong>
                </p>
            </div>

            <div class="panel-body{if !$postingReply && $data.status.id == $settings.default_resolved_status} panel-body-collapsed{/if} card-body collapse in show"
                 id="sp-reply-form">
                <form method="post" action="?number={$data.number|escape}&amp;token={$data.token|escape}" enctype="multipart/form-data" role="form" id="frmReply">
                    <input type="hidden" name="reply" value="1" />

                    <div class="form-group">
                        <label for="inputMessage">{$LANG.contactmessage}</label>
                        <textarea name="replymessage" id="inputMessage" rows="5" class="form-control"></textarea>
                    </div>

                    <div class="row form-group">
                        <div class="col-sm-12">
                            <label for="inputAttachments">{$LANG.supportticketsticketattachments}</label>
                        </div>
                        <div class="col-sm-9">
                            <input type="file" name="attachments[]" id="inputAttachments" class="form-control" />
                            <div id="fileUploadsContainer"></div>
                        </div>
                        <div class="col-sm-3">
                            <button id="sp-extra-attachment" type="button" class="btn btn-default btn-block">
                                <i class="fa fas fa-plus"></i> {$LANG.addmore}
                            </button>
                        </div>
                        <div class="col-sm-12 ticket-attachments-message text-muted">
                            {$LANG.supportticketsallowedextensions}: {$settings.allowed_files|replace:'|':', '|escape}
                        </div>
                    </div>

                    <div class="row form-group">
                        <div class="col-sm-12">
                            <label for="inputAttachments">{$LANG2.ticket_cc}</label>
                        </div>
                        <div class="col-sm-9">
                            {if $data.cc}
                                {foreach from=$data.cc item=email name=cc}
                                    <input type="text" name="cc[]" value="{$email|escape}" class="form-control"
                                           {if !$smarty.foreach.cc.first}style="margin-top: 8px;"{/if} />
                                {/foreach}
                            {else}
                                <input type="text" name="cc[]" class="form-control" />
                            {/if}
                            <div id="ccContainer"></div>
                        </div>
                        <div class="col-sm-3">
                            <button type="button" class="btn btn-default btn-block" id="sp-extra-cc">
                                <i class="fa fas fa-plus"></i> {$LANG.addmore}
                            </button>
                        </div>
                    </div>

                    <div class="text-center">
                        <input class="btn btn-primary" type="submit" name="save" value="{$LANG.supportticketsticketsubmit}" />
                        <input class="btn btn-default" type="reset" value="{$LANG.cancel}" onclick="jQuery('#ticketReply').click()" />
                    </div>
                </form>
            </div>
        </div>
    {/if}

    <div class="card">
        {section loop=$messages name=index}
            {if $messages[index].type == 0}
                <div class="ticket-reply panel{if $messages[index].by == 0} staff{else} panel-default{/if} clearfix">
                    <div class="panel-heading card-header {if $messages[index].by == 0}bg-primary{else}bg-dark{/if} text-white {if !$smarty.section.index.first}rounded-0{/if}">
                        <div class="text-light pull-right float-right">
                            {if $messages[index].by == 0}
                                {$LANG.supportticketsstaff}
                            {else}
                                {$LANG.supportticketsclient}
                            {/if}
                            &nbsp;-&nbsp;
                            {$messages[index].created_at|escape}
                        </div>
                        <div>
                            <strong>{$messages[index].user.formatted_name|escape}</strong>
                        </div>
                    </div>
                    <div class="panel-body card-body">
                        {$messages[index].purified_text}
                    </div>
                    {if count($messages[index].attachments) gt 0}
                        <ul class="list-group list-group-flush">
                            {foreach from=$messages[index].attachments item=attachment}
                                <li class="list-group-item" style="border-width: 1px 0 0;">
                                    <i class="fa fas fa-file"></i>&nbsp;
                                    <a href="?number={$data.number|escape}&amp;token={$data.token|escape}&amp;download_file={$attachment.id|escape}">
                                        {$attachment.original_name|escape} &nbsp;<span class="small text-muted">({$attachment.upload.size|escape})</span>
                                    </a>
                                </li>
                            {/foreach}
                        </ul>
                    {/if}
                </div>
            {/if}
        {/section}
    </div>
{/if}
