var currentPage = 1;
var lastPage = 4;
$("#nextButton").attr('disabled', 'disabled');
$("#prevButton").hide();
$("#submitButton").hide();
$(".formPage").hide();
$("#formPage" + currentPage).show();


$("#giantModalAddForm").find("input").on("input", function () {
    $(this).removeClass("is-invalid");
});


$('#giantModalAddForm').off('submit');
$('#giantModalAddForm').on('submit', function (event) {

    $('.giantModalPanel').hide();
    $('#giantModalSpinnerDiv').show();

    event.preventDefault();
    $.ajax({
        type: 'post',
        data: $(this).serialize(),
        success: function (responseJson) {
            var response = jQuery.parseJSON(responseJson);

            if (response.error) {
                $('#giantModalAlertDiv').show();
                $('#giantModalAlert').html(response.error);
            }
            refreshList("port");
        }
    });
});

$("#checkPortabilityButton").click(function (event) {

    event.preventDefault();
    $("#nextButton").attr('disabled', 'disabled');
    $("#checkPortabilityButton").attr('disabled', 'disabled');
    $("#lcpDiv").hide();
    $(".lcpInfoDiv").hide();
    $.ajax({
        type: 'post',
        data: {
            giantResellerAction: "checkPortability",
            mbn: $("#mbnInput").val(),
            account_number: $("#accountNumberInput").val(),
        },
        success: function (responseJson) {

            $("#checkPortabilityButton").removeAttr('disabled');

            var response = jQuery.parseJSON(responseJson);

            $(".lcpInfoDiv").hide();

            var rh = response.rh;
            if (!rh) {
                $("#lcpInfo0Div").show();
                return;
            }

            $("#mbnShowInput").val($("#mbnInput").val());

            var isPortabilityPossible = response.isPortabilityPossible;

            if (isPortabilityPossible) {
                $("#lcpInfo1Div").show();
            } else {
                $("#lcpInfo2Div").show();
            }

            $("#lcpSelectDiv").hide();
            $(".currentLcpP").text(rh);
            $("#currentRhInput").val(rh);
            $("#lcpDiv").show();
        }
    });
});

function typeMode(mode) {

    let currentType = $("#typeSelect").find(":selected").val();

    if(mode == "sm") {

        if (currentType == 'sub_single' || currentType == 'sub_multi') {
            $("#typeSelect").val("single");
        }

        $("#typeSelect option[value='single']").show();
        $("#typeSelect option[value='multi']").show();

        $("#typeSelect option[value='sub_single']").hide();
        $("#typeSelect option[value='sub_multi']").hide();

    } else {

        if (currentType == 'single' || currentType == 'multi') {
            $("#typeSelect").val("sub_single");
        }

        $("#typeSelect option[value='single']").hide();
        $("#typeSelect option[value='multi']").hide();

        $("#typeSelect option[value='sub_single']").show();
        $("#typeSelect option[value='sub_multi']").show();
    }
}

$("#lcpCorrectButton").click(function (event) {
    event.preventDefault();
    $("#rhModeInput").val("auto");
    $("#lcpSelectDiv").hide();
    $("#nextButton").removeAttr('disabled');

    typeMode("sm");
});

$("#lcpElseButton").click(function (event) {
    event.preventDefault();
    $("#rhModeInput").val("manual");
    $("#lcpSelectDiv").show();
    $("#nextButton").removeAttr('disabled');

    $("#lcpCupidSelect").change();
});

$("#lcpCupidSelect").change(function (event) {

    let detectedLcp = $("#currentRhInput").val();
    let selectedLcp = $(this).val().split("|")[1];

    if(detectedLcp == selectedLcp) {
        typeMode("sm");
    } else {
        typeMode("sssm");
    }
});


$(".removeNumberButton").off("click");
$(".removeNumberButton").click(function (event) {
    event.preventDefault();
    var row = $(this).parent().parent().parent();
    row.remove();
});

$("#addNumberButton").click(function (event) {
    event.preventDefault();
    var row = $(this).parent().parent().parent();
    var before = '<div class="row align-items-end">';

    before += '<div class="col-md-4"><div class="form-group"><label class="col-form-label">Number:</label><div class="input-group mb-3"><div class="input-group-prepend"><span class="input-group-text" id="basic-addon1">+44</span></div><input type="text" class="form-control" name="numberNumber[]" value=""></div></div></div>';
    before += '<div class="col-md-3"><div class="form-group"><label class="col-form-label">Action:</label><select type="text" class="form-control" name="numberAction[]"><option value = "port">Port</option><option value = "retain">Retain</option><option value = "drop">Drop</option></select></div></div>';
    before += '<div class="col-md-3"><div class="form-group"><label class="col-form-label">Type:</label><select type="text" class="form-control" name="numberType[]"><option value = "other">Other</option><option value = "associated">Associated</option></select></div></div>';
    before += '<div class="col-md-2 align-bottom"><div class="form-group"><button class="removeNumberButton btn btn-danger">-</button></div></div>';
    before += '</div>';

    row.before(before);

    //row.before('<div class="row"><div class="col-md-10"><input type="text" class="form-control" name="number[]" value=""></div><div class="col-md-2"><div class="form-group"><button class="removeNumberButton btn btn-danger">-</button></div></div></div>');

    $(".removeNumberButton").off("click");
    $(".removeNumberButton").click(function (event) {
        event.preventDefault();
        var row = $(this).parent().parent().parent();
        row.remove();
    });
    $("#giantModalAddForm").find("input").off("input");
    $("#giantModalAddForm").find("input").on("input", function () {
        $(this).removeClass("is-invalid");
    });

});

var signature = $('#signatureDiv').signature({
    syncField: '#sigpad',
    syncFormat: 'PNG',
    change: function (event, ui) {
        $("#signatureDiv").css("border-color", "#DEE0E3");
    }
});

$('#clearSignatureButton').click(function (e) {
    e.preventDefault();
    signature.signature('clear');
    $("#sigpad").val('');
});

$("#nextButton").click(function (event) {
    event.preventDefault();

    if (currentPage == 2) {

        if (!$("#linesInput").val()) {
            $("#linesInput").addClass("is-invalid");
        }

        if (!$("#channelsInput").val()) {
            $("#channelsInput").addClass("is-invalid");
        }

        $("[name='numberNumber[]']").each(function () {

            var value = $(this).val();
            if (!value || !value.match(/^[0-9]{10}$/)) {
                $(this).addClass("is-invalid");
            }
        });
    }

    if (currentPage == 3) {

        if (!$("#forenameInput").val()) {
            $("#forenameInput").addClass("is-invalid");
        }

        if (!$("#nameInput").val()) {
            $("#nameInput").addClass("is-invalid");
        }
    }

    var find = $("#formPage" + currentPage).find(".is-invalid");

    if (find.length) {
        return false;
    }

    currentPage++;
    if (currentPage > lastPage) {
        currentPage = lastPage;
    }
    if (currentPage == 1) {
        $("#prevButton").hide();
    } else {
        $("#prevButton").show();
    }
    if (currentPage == lastPage) {
        $("#nextButton").hide();
        $("#submitButton").show();
    } else {
        $("#nextButton").show();
        $("#submitButton").hide();
    }

    if (currentPage == lastPage) {
        let type = $("#typeSelect").val();
        let daysByType = {
            single: 4,
            multi: 7,
            sub_single: 7,
            sub_multi: 10,
        };

        let days = daysByType[type] + 1;
        let startDate = new Date();
        let count = 0;

        while(count < days) {
            startDate.setDate(startDate.getDate() + 1);
            if(startDate.getDay() != 0 && startDate.getDay() != 6) {
                count++;
            }
        }

        $("#portDateInput").val("");
        $("#portDateInput").datepicker("destroy");
        $("#portDateInput").datepicker(
            {
                dateFormat: 'yy-mm-dd',
                minDate: startDate,
                beforeShowDay: $.datepicker.noWeekends,
                onSelect: function (dateText, inst) {
                    $("#portDateInput").removeClass("is-invalid");
                }
            }
        );
    }

    $(".formPage").hide();
    $("#formPage" + currentPage).show();
});

$("#prevButton").click(function (event) {
    event.preventDefault();
    currentPage--;
    if (currentPage < 1) {
        currentPage = 1;
    }
    if (currentPage == 1) {
        $("#prevButton").hide();
    } else {
        $("#prevButton").show();
    }
    if (currentPage == lastPage) {
        $("#nextButton").hide();
        $("#submitButton").show();
    } else {
        $("#nextButton").show();
        $("#submitButton").hide();
    }
    $(".formPage").hide();
    $("#formPage" + currentPage).show();
});


$("#submitButton").click(function (event) {

    var emptySignature = true;
    if (signature.signature('isEmpty')) {
        emptySignature = true;
        $("#signatureDiv").css("border-color", "red");
    } else {
        emptySignature = false;
    }

    $("#formPage" + currentPage).find("input").each(function () {
        if (!$(this).val() && $(this).attr("name") != "company") {
            $(this).addClass("is-invalid");
        }
    });

    var find = $("#formPage" + currentPage).find(".is-invalid");

    if (find.length || emptySignature) {
        return false;
    } else {
        return true;
    }
});


    