{if $success_message}
    <div class="successbox">
        <strong><span class="title">{$LANG.changes_saved}</span></strong><br />
        {$success_message}
    </div>
    <br />
{/if}
{if $error_message}
    <div class="errorbox">
        <strong><span class="title">{$LANG.changes_not_saved}</span></strong><br />
        {$error_message}
    </div>
    <br />
{/if}

<div class="form-row">
    <label>{$LANG.status}</label>
    <div class="input-container">
        {if $integration_status == 0}
            <strong style="color: #27ae60; text-transform: uppercase;">{$LANG.active}</strong><br />
            <span class="description">{$LANG.active_desc}</span>
        {elseif $integration_status == 1}
            <strong style="color: #c0392b; text-transform: uppercase;">{$LANG.error} {if isset($integration_error)} - {$integration_error}{/if}</strong><br />
            <span class="description">{$LANG.error_desc}</span>
        {elseif $integration_status == 2}
            <strong style="color: #e67e22; text-transform: uppercase;">{$LANG.not_configured}</strong><br />
            <span class="description">{$LANG.not_configured_desc}</span>
        {/if}
    </div>
</div>

<form method="POST" action="{$modulelink}" accept-charset="UTF-8">

    <input name="validate_token" type="hidden" value="{$validate_token}" />

    <h2>{$LANG.authentication}</h2>

    <div class="form-container first">
        <div class="form-row">
            <label>{$LANG.base_url}</label>
            <div class="input-container">
                <input name="base_url" type="text" value="{$supportpal.base_url}" placeholder="http://www.yourdomain.com/support/" size="55" /><br />
                <span class="description">{$LANG.base_url_desc}</span>
            </div>
        </div>

        <div class="form-row">
            <label>{$LANG.admin_url}</label>
            <div class="input-container">
                <input name="admin_url" type="text" value="{$supportpal.admin_url}" placeholder="http://www.yourdomain.com/support/admin/" size="55" /><br />
                <span class="description">{$LANG.admin_url_desc}</span>
            </div>
        </div>

        <div class="form-row">
            <label>{$LANG.api_token}</label>
            <div class="input-container">
                <input name="api_token" type="text" value="{$supportpal.api_token}" size="45" /><br />
                <span class="description">{$LANG.api_token_desc}</span>
            </div>
        </div>

        <div class="form-row">
            <label>{$LANG.brand}</label>
            <div class="input-container">
                <input name="brand_id" type="text" value="{$supportpal.brand_id}" size="3" /><br />
                <span class="description">{$LANG.brand_desc}</span>
            </div>
        </div>

        <div class="form-row">
            <div class="input-container">
                <input type="button" class="btn btn-default validate-button" value="{$LANG.validate_authentication}" />
                &nbsp;&nbsp;
                <span class="validate text-progress sp-hide">
                    <i class='fa fas fa-spinner fa-spin'></i>&nbsp; {$LANG.in_progress}...
                </span>
                <span class="validate text-success sp-hide">{$LANG.success}!</span>
                <span class="validate text-fail sp-hide">
                    {$LANG.error}!
                    <span class="error-message"></span>
                </span>
            </div>
        </div>
    </div>

    <br />

    <h2>{$LANG.ticket_settings}</h2>

    <div class="form-container first">
        <div class="form-row">
            <label>{$LANG.related_field}</label>
            <div class="input-container">
                <input name="related_service_field" type="text" value="{$supportpal.related_service_field}" size="3" /><br />
                <span class="description">{$LANG.related_field_desc}</span>
            </div>
        </div>

        <div class="form-row">
            <label>{$LANG.article_suggestions}</label>
            <div class="input-container">
                <input name="article_suggestions" id="toggle_article_suggestions" type="checkbox" value="1" class="toggle" {if $supportpal.article_suggestions}checked="checked"{/if} />
                <label for="toggle_article_suggestions"></label><br />
                <span class="description">{$LANG.article_suggestions_desc}</span>
            </div>
        </div>
    </div>

    <br />

    <h2>{$LANG.self_service_types}</h2>

    <h3 class="description">{$LANG.self_service_types_desc}</h3>

    <div class="form-container first">
        <div class="form-row">
            <label>{$LANG.announcements}</label>
            <div class="input-container">
                <div style="margin-bottom: 1rem;">
                    <input name="announcements_enabled" id="toggle_announcements_enabled" type="checkbox" value="1" class="toggle" {if $supportpal.announcements_enabled}checked="checked"{/if} />
                    <label for="toggle_announcements_enabled"></label>
                </div>
                <div class="announcements-id {if !$supportpal.announcements_enabled}sp-hide{/if}">
                    <input name="announcements_id" type="text" value="{$supportpal.announcements_id}" size="3" /><br />
                    <span class="description">{$LANG.announcements_desc}</span>
                </div>
            </div>
        </div>

        <div class="form-row">
            <label>{$LANG.knowledgebase}</label>
            <div class="input-container">
                <div style="margin-bottom: 1rem;">
                    <input name="knowledgebase_enabled" id="toggle_knowledgebase_enabled" type="checkbox" value="1" class="toggle" {if $supportpal.knowledgebase_enabled}checked="checked"{/if} />
                    <label for="toggle_knowledgebase_enabled"></label>
                </div>
                <div class="knowledgebase-id {if !$supportpal.knowledgebase_enabled}sp-hide{/if}">
                    <input name="knowledgebase_id" type="text" value="{$supportpal.knowledgebase_id}" size="3" /><br />
                    <span class="description">{$LANG.knowledgebase_desc}</span>
                </div>
            </div>
        </div>

        <div class="form-row">
            <label>{$LANG.downloads}</label>
            <div class="input-container">
                <div style="margin-bottom: 1rem;">
                    <input name="downloads_enabled" id="toggle_downloads_enabled" type="checkbox" value="1" class="toggle" {if $supportpal.downloads_enabled}checked="checked"{/if} />
                    <label for="toggle_downloads_enabled"></label>
                </div>
                <div class="downloads-id {if !$supportpal.downloads_enabled}sp-hide{/if}">
                    <input name="downloads_id" type="text" value="{$supportpal.downloads_id}" size="3" /><br />
                    <span class="description">{$LANG.downloads_desc}</span>
                </div>
            </div>
        </div>

        <div class="form-row">
            <div class="input-container">
                <input type="button" class="btn btn-default validate-types-button" value="{$LANG.validate_types}" />
                &nbsp;&nbsp;
                <span class="validate_types text-progress sp-hide">
                    <i class='fa fas fa-spinner fa-spin'></i>&nbsp; {$LANG.in_progress}...
                </span>
                <span class="validate_types text-success sp-hide">{$LANG.success}!</span>
                <span class="validate_types text-fail sp-hide">
                    {$LANG.error}!
                    <span class="error-message"></span>
                </span>
            </div>
        </div>
    </div>

    <br />

    <input type="submit" class="btn btn-primary" value="{$LANG.save}" />

</form>

<link href="../modules/addons/supportpal/assets/css/main.css" rel="stylesheet" type="text/css">
<script type="text/javascript" src="../modules/addons/supportpal/assets/js/main.js"></script>
