<?php

declare (strict_types=1);

/**
 * SupportPal Integration Addon - Authentication Validation
 *
 * Validate the authentication details provided for SupportPal.
 *
 * @category    SupportPal
 * @package     SupportPal Integration
 * @copyright   Copyright (c) 2016-2019 SupportPal
 * @version     4.0.0
 * @since       File available since version 3.2.0
 */
require_once __DIR__ . '/../../../modules/support/supportpal/Bootstrap/app.php';
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\ApiContext;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\SupportPal;
use SupportPal\WhmcsIntegration\DI\Container;
use SupportPal\WhmcsIntegration\Factory\RequestDefaultsFactory;
use SupportPal\WhmcsIntegration\Factory\SupportPalFactory;
use SupportPal\WhmcsIntegration\Helper\TransientDataHelper;
use SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Router\IntegrationSettingsValidationRouter;
use SupportPal\WhmcsIntegration\SupportPalApiClientWrapper;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\JsonResponse;
$request = \SupportPal\WhmcsIntegration\Request\Request::createFromGlobals();
$baseUrl = $request->get('base_url');
$apiToken = $request->get('api_token');
$brandId = $request->get('brand_id');
if (empty($baseUrl) || empty($apiToken) || empty($brandId)) {
    (new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\JsonResponse(['status' => 'error', 'message' => 'Missing either the base URL, API token or Brand ID.']))->send();
    exit;
}
try {
    $clientWrapper = new \SupportPal\WhmcsIntegration\SupportPalApiClientWrapper(new \SupportPal\WhmcsIntegration\Factory\SupportPalFactory(), new \SupportPal\WhmcsIntegration\Factory\RequestDefaultsFactory(), new \SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository(), new \SupportPal\WhmcsIntegration\Helper\TransientDataHelper(), new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\SupportPal(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\ApiContext::createFromUrl($baseUrl, $apiToken)));
} catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException $invalidConfigurationException) {
    (new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\JsonResponse(['status' => 'error', 'message' => $invalidConfigurationException->getMessage()]))->send();
    exit;
}
$container = \SupportPal\WhmcsIntegration\DI\Container::getCustomContainer($clientWrapper);
/** @var IntegrationSettingsValidationRouter $router */
$router = $container->get(\SupportPal\WhmcsIntegration\Router\IntegrationSettingsValidationRouter::class);
$router->route($request, (int) $brandId);
