<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

use Exception;
use function bin2hex;
use function random_bytes;
/**
 * Class CsrfTokenHelper
 * @package SupportPal\WhmcsIntegration\Helper
 */
class CsrfTokenHelper
{
    private const TOKEN = 'supportpal_csrf_token';
    /** @var SessionHelper */
    private $sessionHelper;
    /**
     * CsrfTokenHelper constructor.
     * @param SessionHelper $sessionHelper
     */
    public function __construct(\SupportPal\WhmcsIntegration\Helper\SessionHelper $sessionHelper)
    {
        $this->sessionHelper = $sessionHelper;
    }
    /**
     * @return string
     * @throws Exception
     */
    public function generateToken() : string
    {
        $token = \bin2hex(\random_bytes(32));
        $this->sessionHelper->set(self::TOKEN, $token);
        return $token;
    }
    /**
     * @param string $token
     * @return bool
     */
    public function validateToken(string $token) : bool
    {
        return $this->sessionHelper->get(self::TOKEN) === $token;
    }
}
