<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

/**
 * Class SessionHelper
 * @package SupportPal\WhmcsIntegration\Helper
 */
class SessionHelper
{
    private const CAPTCHA_PHRASE = 'supportpal_phrase';
    /**
     * @param string $key
     * @param null $default
     * @return mixed|null
     */
    public function get(string $key, $default = null)
    {
        return $_SESSION[$key] ?? $default;
    }
    /**
     * @param string $key
     * @param mixed $value
     */
    public function set(string $key, $value) : void
    {
        $_SESSION[$key] = $value;
    }
    /**
     * @param string|null $phrase
     */
    public function setCaptchaPhrase(?string $phrase) : void
    {
        $this->set(self::CAPTCHA_PHRASE, $phrase);
    }
    /**
     * @return string|null
     */
    public function getCaptchaPhrase() : ?string
    {
        return $this->get(self::CAPTCHA_PHRASE);
    }
}
