<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

use function preg_replace;
use function str_replace;
use function strlen;
use function strtolower;
/**
 * Class StringHelper
 * @package SupportPal\WhmcsIntegration\Helper
 */
class StringHelper
{
    private const MATCHING_SYMBOLS = [
        // Day
        'd' => 'dd',
        'D' => 'D',
        'j' => 'd',
        'l' => 'DD',
        'N' => '',
        'S' => '',
        'w' => '',
        'z' => 'o',
        // Week
        'W' => '',
        // Month
        'F' => 'MM',
        'm' => 'mm',
        'M' => 'M',
        'n' => 'm',
        't' => '',
        // Year
        'L' => '',
        'o' => '',
        'Y' => 'yy',
        'y' => 'y',
        // Time
        'a' => '',
        'A' => '',
        'B' => '',
        'g' => '',
        'G' => '',
        'h' => '',
        'H' => '',
        'i' => '',
        's' => '',
        'u' => '',
    ];
    /**
     * Matches each symbol of PHP date format standard with jQuery equivalent codeword
     * @author Tristan Jahier
     * @param string $phpFormat
     * @return string
     */
    public function formatDatePHPToJqueryUI(string $phpFormat) : string
    {
        $jqueryUIFormat = '';
        $escaping = \false;
        for ($i = 0; $i < \strlen($phpFormat); ++$i) {
            $char = $phpFormat[$i];
            if ($char === '\\') {
                // PHP date format escaping character
                ++$i;
                $jqueryUIFormat .= $escaping ? $phpFormat[$i] : '\'' . $phpFormat[$i];
                $escaping = \true;
            } else {
                if ($escaping) {
                    $jqueryUIFormat .= "'";
                    $escaping = \false;
                }
                $jqueryUIFormat .= isset(self::MATCHING_SYMBOLS[$char]) ? self::MATCHING_SYMBOLS[$char] : $char;
            }
        }
        return $jqueryUIFormat;
    }
    /**
     * Converts a string to a slug
     *
     * @param string $url
     * @return string
     */
    public function getUrlSlug(string $url) : string
    {
        // credit to http://www.papersoup.org/post/seo-friendly-url-slugs-php
        $parser = '-';
        $retSlug = (string) \preg_replace('/[^A-Za-z0-9 +-]+/', '', $url);
        // alphanumeric, spaces, dashes, plus sign etc
        $retSlug = \str_replace(' ', $parser, $retSlug);
        // convert spaces into our style
        return \strtolower($retSlug);
    }
}
