<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Log;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use function sprintf;
class RequestLogger
{
    private const MODULE_NAME = 'mod_supportpal';
    /** @var RequestLogFormatter */
    private $requestLogFormatter;
    /** @var ResponseLogFormatter */
    private $responseLogFormatter;
    /** @var LogModuleWrapper */
    private $logModuleWrapper;
    /**
     * RequestLogger constructor.
     * @param ResponseLogFormatter $responseLogFormatter
     * @param RequestLogFormatter $requestLogFormatter
     * @param LogModuleWrapper $logModuleWrapper
     */
    public function __construct(\SupportPal\WhmcsIntegration\Log\ResponseLogFormatter $responseLogFormatter, \SupportPal\WhmcsIntegration\Log\RequestLogFormatter $requestLogFormatter, \SupportPal\WhmcsIntegration\Log\LogModuleWrapper $logModuleWrapper)
    {
        $this->responseLogFormatter = $responseLogFormatter;
        $this->requestLogFormatter = $requestLogFormatter;
        $this->logModuleWrapper = $logModuleWrapper;
    }
    /**
     * @param Exception $exception
     * @param string $action
     * @param RequestInterface $request
     * @param ResponseInterface|null $response
     */
    public function log(\Exception $exception, string $action, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, ?\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response = null) : void
    {
        $module = self::MODULE_NAME;
        $action = \sprintf('Action: %s - Exception Message: %s', $action, $exception->getMessage());
        $request = $this->requestLogFormatter->withGlobals()->format($request);
        $response = $response !== null ? $this->responseLogFormatter->format($response) : '';
        $this->logModuleWrapper->log($module, $action, $request, $response);
    }
}
