<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Log;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface;
class ResponseLogFormatter
{
    /** @var EncoderInterface */
    private $encoder;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface $encoder)
    {
        $this->encoder = $encoder;
    }
    public function format(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response) : string
    {
        $headers = $this->encoder->encode($response->getHeaders(), 'json');
        $body = (string) $response->getBody();
        $reason = (string) $response->getReasonPhrase();
        $status = (string) $response->getStatusCode();
        $data = ['headers' => $headers, 'body' => $body, 'reason' => $reason, 'status' => $status];
        return $this->encoder->encode($data, 'json');
    }
}
