<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Category;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class CategoryRepository
 * @package SupportPal\WhmcsIntegration\Repository\SelfService
 */
class CategoryRepository extends \SupportPal\WhmcsIntegration\Repository\SelfService\BaseSelfServiceRepository
{
    /**
     * @param int $id
     * @return Category
     * @throws InvalidApiResponse
     */
    public function find(int $id) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Category
    {
        return $this->callAndMapException(function () use($id) {
            return $this->getApi()->getCategory($id);
        }, 'getCategory');
    }
    /**
     * @param mixed[] $data
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findBy(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($data) {
            return $this->getApi()->getCategories($data);
        }, 'getCategories');
    }
}
