<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Tag;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
class TagRepository extends \SupportPal\WhmcsIntegration\Repository\SelfService\BaseSelfServiceRepository
{
    /**
     * @param int $id
     * @return Tag
     * @throws InvalidApiResponse
     */
    public function find(int $id) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Tag
    {
        return $this->callAndMapException(function () use($id) {
            return $this->getApi()->getTag($id);
        }, 'getTag');
    }
}
