<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Service\Converter;

use Closure;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter as ModelToArrayConverterInternal;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
use function array_map;
class ModelToArrayConverter
{
    /** @var ModelToArrayConverterInternal */
    private $modelToArrayConverter;
    /**
     * ModelToArrayConverter constructor.
     * @param ModelToArrayConverterInternal $modelToArrayConverter
     */
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter $modelToArrayConverter)
    {
        $this->modelToArrayConverter = $modelToArrayConverter;
    }
    /**
     * @param Model $model
     * @return array<mixed>
     */
    public function convertOne(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model $model) : array
    {
        return $this->modelToArrayConverter->convertOne($model);
    }
    /**
     * @param Model $model
     * @param Closure ...$closures
     * @return array<mixed>
     */
    public function convertOneAndApply(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model $model, \Closure ...$closures) : array
    {
        $arrayValue = $this->convertOne($model);
        foreach ($closures as $closure) {
            $arrayValue = $closure($arrayValue);
        }
        return $arrayValue;
    }
    /**
     * @param mixed[] $models
     * @return mixed[]
     */
    public function convertMany(array $models) : array
    {
        return \array_map([$this, 'convertOne'], $models);
    }
    /**
     * @param mixed[] $models
     * @param Closure ...$closures
     * @return mixed[]
     */
    public function convertManyAndApply(array $models, \Closure ...$closures) : array
    {
        return \array_map(function (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model $model) use($closures) {
            return $this->convertOneAndApply($model, ...$closures);
        }, $models);
    }
}
