<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Service\Manager\Ticket;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateTicket;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\SupportPalApiClientWrapper;
/**
 * Class TicketManager
 * @package SupportPal\WhmcsIntegration\Service\Manager\Ticket
 */
class TicketManager
{
    /** @var TicketApi */
    private $ticketApi;
    /**
     * TicketManager constructor.
     * @param SupportPalApiClientWrapper $apiClient
     * @throws Exception
     */
    public function __construct(\SupportPal\WhmcsIntegration\SupportPalApiClientWrapper $apiClient)
    {
        $this->ticketApi = $apiClient->getSupportPal()->getTicketApi();
    }
    /**
     * @param mixed[] $data
     * @return Ticket
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function create(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket
    {
        /** @var CreateTicket $createTicket */
        $createTicket = (new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateTicket())->fill($data);
        try {
            return $this->ticketApi->postTicket($createTicket);
        } catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\InvalidApiResponse($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
    }
    /**
     * @param Ticket $ticket
     * @param mixed[] $data
     * @return Ticket
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function update(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket $ticket, array $data)
    {
        try {
            return $this->ticketApi->updateTicket($ticket, $data);
        } catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\InvalidApiResponse($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
    }
}
