<?php

namespace SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache;

use SupportPal\WhmcsIntegration\Vendor\Predis\ClientInterface;
use function array_combine;
use function array_filter;
use function array_map;
use function array_values;
use function call_user_func_array;
use function serialize;
use function unserialize;
/**
 * Predis cache provider.
 *
 * @deprecated Deprecated without replacement in doctrine/cache 1.11. This class will be dropped in 2.0
 */
class PredisCache extends \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\CacheProvider
{
    /** @var ClientInterface */
    private $client;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Predis\ClientInterface $client)
    {
        $this->client = $client;
    }
    /**
     * {@inheritdoc}
     */
    protected function doFetch($id)
    {
        $result = $this->client->get($id);
        if ($result === null) {
            return \false;
        }
        return \unserialize($result);
    }
    /**
     * {@inheritdoc}
     */
    protected function doFetchMultiple(array $keys)
    {
        $fetchedItems = \call_user_func_array([$this->client, 'mget'], \array_values($keys));
        return \array_map('unserialize', \array_filter(\array_combine($keys, $fetchedItems)));
    }
    /**
     * {@inheritdoc}
     */
    protected function doSaveMultiple(array $keysAndValues, $lifetime = 0)
    {
        if ($lifetime) {
            $success = \true;
            // Keys have lifetime, use SETEX for each of them
            foreach ($keysAndValues as $key => $value) {
                $response = (string) $this->client->setex($key, $lifetime, \serialize($value));
                if ($response == 'OK') {
                    continue;
                }
                $success = \false;
            }
            return $success;
        }
        // No lifetime, use MSET
        $response = $this->client->mset(\array_map(static function ($value) {
            return \serialize($value);
        }, $keysAndValues));
        return (string) $response == 'OK';
    }
    /**
     * {@inheritdoc}
     */
    protected function doContains($id)
    {
        return (bool) $this->client->exists($id);
    }
    /**
     * {@inheritdoc}
     */
    protected function doSave($id, $data, $lifeTime = 0)
    {
        $data = \serialize($data);
        if ($lifeTime > 0) {
            $response = $this->client->setex($id, $lifeTime, $data);
        } else {
            $response = $this->client->set($id, $data);
        }
        return $response === \true || $response == 'OK';
    }
    /**
     * {@inheritdoc}
     */
    protected function doDelete($id)
    {
        return $this->client->del($id) >= 0;
    }
    /**
     * {@inheritdoc}
     */
    protected function doDeleteMultiple(array $keys)
    {
        return $this->client->del($keys) >= 0;
    }
    /**
     * {@inheritdoc}
     */
    protected function doFlush()
    {
        $response = $this->client->flushdb();
        return $response === \true || $response == 'OK';
    }
    /**
     * {@inheritdoc}
     */
    protected function doGetStats()
    {
        $info = $this->client->info();
        return [\SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache::STATS_HITS => $info['Stats']['keyspace_hits'], \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache::STATS_MISSES => $info['Stats']['keyspace_misses'], \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache::STATS_UPTIME => $info['Server']['uptime_in_seconds'], \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache::STATS_MEMORY_USAGE => $info['Memory']['used_memory'], \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache::STATS_MEMORY_AVAILABLE => \false];
    }
}
