<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestFactoryInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseFactoryInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ServerRequestFactoryInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ServerRequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamFactoryInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UploadedFileFactoryInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UploadedFileInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UriFactoryInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UriInterface;
/**
 * Implements all of the PSR-17 interfaces.
 *
 * Note: in consuming code it is recommended to require the implemented interfaces
 * and inject the instance of this class multiple times.
 */
final class HttpFactory implements \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestFactoryInterface, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseFactoryInterface, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ServerRequestFactoryInterface, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamFactoryInterface, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UploadedFileFactoryInterface, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UriFactoryInterface
{
    public function createUploadedFile(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface $stream, int $size = null, int $error = \UPLOAD_ERR_OK, string $clientFilename = null, string $clientMediaType = null) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UploadedFileInterface
    {
        if ($size === null) {
            $size = $stream->getSize();
        }
        return new \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\UploadedFile($stream, $size, $error, $clientFilename, $clientMediaType);
    }
    public function createStream(string $content = '') : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface
    {
        return \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Utils::streamFor($content);
    }
    public function createStreamFromFile(string $file, string $mode = 'r') : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface
    {
        try {
            $resource = \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Utils::tryFopen($file, $mode);
        } catch (\RuntimeException $e) {
            if ('' === $mode || \false === \in_array($mode[0], ['r', 'w', 'a', 'x', 'c'], \true)) {
                throw new \InvalidArgumentException(\sprintf('Invalid file opening mode "%s"', $mode), 0, $e);
            }
            throw $e;
        }
        return \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Utils::streamFor($resource);
    }
    public function createStreamFromResource($resource) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface
    {
        return \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Utils::streamFor($resource);
    }
    public function createServerRequest(string $method, $uri, array $serverParams = []) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ServerRequestInterface
    {
        if (empty($method)) {
            if (!empty($serverParams['REQUEST_METHOD'])) {
                $method = $serverParams['REQUEST_METHOD'];
            } else {
                throw new \InvalidArgumentException('Cannot determine HTTP method');
            }
        }
        return new \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\ServerRequest($method, $uri, [], null, '1.1', $serverParams);
    }
    public function createResponse(int $code = 200, string $reasonPhrase = '') : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return new \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Response($code, [], null, '1.1', $reasonPhrase);
    }
    public function createRequest(string $method, $uri) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface
    {
        return new \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Request($method, $uri);
    }
    public function createUri(string $uri = '') : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\UriInterface
    {
        return new \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Uri($uri);
    }
}
