<?php

namespace SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy;

use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
interface CacheStrategyInterface
{
    /**
     * Return a CacheEntry or null if no cache.
     *
     * @param RequestInterface $request
     *
     * @return CacheEntry|null
     */
    public function fetch(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request);
    /**
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     *
     * @return bool true if success
     */
    public function cache(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response);
    /**
     * @param RequestInterface $request
     * @param ResponseInterface $response
     *
     * @return bool true if success
     */
    public function update(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response);
    /**
     * @param RequestInterface $request
     *
     * @return bool
     */
    public function delete(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request);
}
