<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Description;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\DescriptionFactory;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Context as TypeContext;
use SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert;
use function preg_match;
/**
 * Reflection class for a {@}version tag in a Docblock.
 */
final class Version extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags\BaseTag implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags\Factory\StaticMethod
{
    /** @var string */
    protected $name = 'version';
    /**
     * PCRE regular expression matching a version vector.
     * Assumes the "x" modifier.
     */
    public const REGEX_VECTOR = '(?:
        # Normal release vectors.
        \\d\\S*
        |
        # VCS version vectors. Per PHPCS, they are expected to
        # follow the form of the VCS name, followed by ":", followed
        # by the version vector itself.
        # By convention, popular VCSes like CVS, SVN and GIT use "$"
        # around the actual version vector.
        [^\\s\\:]+\\:\\s*\\$[^\\$]+\\$
    )';
    /** @var string|null The version vector. */
    private $version;
    public function __construct(?string $version = null, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Description $description = null)
    {
        \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::nullOrStringNotEmpty($version);
        $this->version = $version;
        $this->description = $description;
    }
    public static function create(?string $body, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\DescriptionFactory $descriptionFactory = null, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Context $context = null) : ?self
    {
        if (empty($body)) {
            return new static();
        }
        $matches = [];
        if (!\preg_match('/^(' . self::REGEX_VECTOR . ')\\s*(.+)?$/sux', $body, $matches)) {
            return null;
        }
        $description = null;
        if ($descriptionFactory !== null) {
            $description = $descriptionFactory->create($matches[2] ?? '', $context);
        }
        return new static($matches[1], $description);
    }
    /**
     * Gets the version section of the tag.
     */
    public function getVersion() : ?string
    {
        return $this->version;
    }
    /**
     * Returns a string representation for this tag.
     */
    public function __toString() : string
    {
        if ($this->description) {
            $description = $this->description->render();
        } else {
            $description = '';
        }
        $version = (string) $this->version;
        return $version . ($description !== '' ? ($version !== '' ? ' ' : '') . $description : '');
    }
}
