<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tag;
// phpcs:ignore SlevomatCodingStandard.Classes.SuperfluousInterfaceNaming.SuperfluousSuffix
interface DocBlockFactoryInterface
{
    /**
     * Factory method for easy instantiation.
     *
     * @param array<string, class-string<Tag>> $additionalTags
     */
    public static function createInstance(array $additionalTags = []) : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlockFactory;
    /**
     * @param string|object $docblock
     */
    public function create($docblock, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Context $context = null, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Location $location = null) : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock;
}
