<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment;
use TypeError;
use function array_map;
trait AttachmentApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getAttachments(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getAttachments($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createAttachment'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $attachmentId
     * @return Attachment
     * @throws HttpResponseException
     */
    public function getAttachment(int $attachmentId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment
    {
        $response = $this->getApiClient()->getAttachment($attachmentId);
        return $this->createAttachment($this->decodeBody($response)['data']);
    }
    /**
     * @param Attachment $attachment
     * @return StreamInterface
     * @throws HttpResponseException
     * @throws MissingIdentifierException
     */
    public function downloadAttachment(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment $attachment) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface
    {
        try {
            $attachmentId = $attachment->getId();
        } catch (\TypeError $typeError) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException('missing attachment identifier');
        }
        return $this->getApiClient()->downloadAttachment($attachmentId)->getBody();
    }
    /**
     * @param array<mixed> $data
     * @return Attachment
     */
    private function createAttachment(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment
    {
        /** @var Attachment $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
