<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings;
/**
 * Trait SettingsApis, includes all related ApiCalls pre and post processing to ticket settings
 * @package SupportPal\ApiClient\Api\Ticket
 */
trait SettingsApis
{
    use ApiAware;
    /**
     * This method fetches all ticket settings
     * @return Settings
     * @throws HttpResponseException
     */
    public function getSettings() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings
    {
        $response = $this->getApiClient()->getSettings();
        /** @var Settings $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings::class, $this->decodeBody($response)['data']);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
