<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\AttachmentApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\ChannelSettingsApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\CustomFieldApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\DepartmentApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\MessageApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\PriorityApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\SettingsApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\StatusApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket\TicketApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
/**
 * Contains all ApiCalls pre and post processing that falls under Tickets Module
 * @package SupportPal\ApiClient\Api
 */
class TicketApi extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Api
{
    use AttachmentApis;
    use ChannelSettingsApis;
    use CustomFieldApis;
    use DepartmentApis;
    use PriorityApis;
    use MessageApis;
    use SettingsApis;
    use StatusApis;
    use TicketApis;
    /** @var TicketApiClient */
    protected $apiClient;
    /**
     * @return TicketApiClient
     */
    protected function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient
    {
        return $this->apiClient;
    }
}
