<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\User;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\UserCustomField;
use function array_map;
trait CustomFieldApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getCustomFields(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getCustomFields($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createUserCustomField'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $customFieldId
     * @return UserCustomField
     * @throws HttpResponseException
     */
    public function getCustomField(int $customFieldId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\UserCustomField
    {
        $response = $this->getApiClient()->getCustomField($customFieldId);
        return $this->createUserCustomField($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return UserCustomField
     */
    private function createUserCustomField(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\UserCustomField
    {
        /** @var UserCustomField $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\UserCustomField::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
}
