<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\User;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\ApiClientAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
trait UserGroupApis
{
    use ApiClientAware;
    /**
     * @param array<mixed> $parameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getGroups(array $parameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USERGROUP, $parameters);
    }
    /**
     * @param int $userGroupId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getGroup(int $userGroupId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::USER_USERGROUP . '/' . $userGroupId, []);
    }
}
