<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache;

use SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\ArrayCache;
use SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\ChainCache;
use SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\FilesystemCache;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\KeyValueHttpHeader;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\DoctrineCacheStorage;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\Delegate\DelegatingCacheStrategy;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\GreedyCacheStrategy;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\NullCacheStrategy;
class CacheStrategyConfigurator
{
    /** @var ApiCacheMap */
    private $apiCacheMap;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache\ApiCacheMap $apiCacheMap)
    {
        $this->apiCacheMap = $apiCacheMap;
    }
    /**
     * This function sets the cache strategy used in the application.
     * By default, endpoints will not be cached unless specified per path, per method.
     * We also use two types of cache, ArrayCache, and FileSystem cache sorted from faster to slower.
     * We always use a greedy strategy (ignore headers returned by the server)
     *
     * read more @https://github.com/Kevinrob/guzzle-cache-middleware
     * @param string $cacheDir
     * @param string $baseApiPath
     * @return CacheStrategyInterface
     */
    public function buildCacheStrategy(string $cacheDir, string $baseApiPath) : \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface
    {
        $delegatingCacheStrategy = new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\Delegate\DelegatingCacheStrategy(new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\NullCacheStrategy());
        /**
         * For every set of Apis, clustered by a default TTL, we create a cache storage.
         */
        foreach ($this->apiCacheMap->getCacheableApis($baseApiPath) as $ttl => $apis) {
            $cacheStorage = new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\DoctrineCacheStorage(new \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\ChainCache([new \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\ArrayCache(), new \SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\FilesystemCache($cacheDir)]));
            $cacheStrategy = new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\GreedyCacheStrategy($cacheStorage, $ttl, new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\KeyValueHttpHeader(['Authorization']));
            /**
             * request matcher handlers linking the caching strategy to every specific endpoint
             */
            $delegatingCacheStrategy->registerRequestMatcher(new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache\CacheableRequestMatcher($apis), $cacheStrategy);
        }
        return $delegatingCacheStrategy;
    }
}
