<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Client;
use SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\ClientInterface;
use SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\HandlerStack;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheMiddleware;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\CoreApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfServiceApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache\ApiCacheMap;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache\CacheStrategyConfigurator;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\ApiContext;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\RequestDefaults;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\RequestFactory;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Config\FileLocator;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\DependencyInjection\ContainerBuilder;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use function array_merge;
use function str_replace;
use function sys_get_temp_dir;
/**
 * Class SupportPal
 * @package SupportPal\ApiClient
 */
class SupportPal
{
    /** @var ContainerBuilder */
    private $containerBuilder;
    /**
     * SupportPal constructor.
     * @param ApiContext $apiContext
     * @param RequestDefaults|null $requestDefaults
     * @param string|null $cacheDir
     * @throws Exception
     */
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\ApiContext $apiContext, ?\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\RequestDefaults $requestDefaults = null, ?string $cacheDir = null)
    {
        $cacheDir = $cacheDir ?? \sys_get_temp_dir();
        $requestDefaults = $requestDefaults ?? new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\RequestDefaults();
        $containerBuilder = new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\DependencyInjection\ContainerBuilder();
        $loader = new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\DependencyInjection\Loader\YamlFileLoader($containerBuilder, new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Config\FileLocator(__DIR__));
        $loader->load('Resources/services.yml');
        $containerBuilder->setParameter('apiUrl', $this->escapeSpecialCharacters($apiContext->getApiUrl()));
        $containerBuilder->setParameter('apiToken', $this->escapeSpecialCharacters($apiContext->getApiToken()));
        $containerBuilder->setParameter('defaultParameters', $requestDefaults->getDefaultParameters());
        $containerBuilder->setParameter('defaultBodyContent', $requestDefaults->getDefaultBodyContent());
        $containerBuilder->set(\SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Client::class, $this->getGuzzleClient($apiContext, $requestDefaults->getDefaultRequestOptions(), $cacheDir));
        $containerBuilder->compile();
        $this->containerBuilder = $containerBuilder;
    }
    /**
     * This method returns the api for SupportPal system
     * @return TicketApi
     * @throws Exception
     */
    public function getTicketApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi
    {
        /** @var TicketApi $api */
        $api = $this->containerBuilder->get(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi::class);
        return $api;
    }
    /**
     * This method returns the api for SupportPal system
     * @return CoreApi
     * @throws Exception
     */
    public function getCoreApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\CoreApi
    {
        /** @var CoreApi $api */
        $api = $this->containerBuilder->get(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\CoreApi::class);
        return $api;
    }
    /**
     * This method returns the api for SupportPal system
     * @return SelfServiceApi
     * @throws Exception
     */
    public function getSelfServiceApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfServiceApi
    {
        /** @var SelfServiceApi $api */
        $api = $this->containerBuilder->get(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfServiceApi::class);
        return $api;
    }
    /**
     * This method returns the api for SupportPal system
     * @return UserApi
     * @throws Exception
     */
    public function getUserApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi
    {
        /** @var UserApi $api */
        $api = $this->containerBuilder->get(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi::class);
        return $api;
    }
    /**
     * @return RequestFactory
     * @throws Exception
     */
    public function getRequestFactory() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\RequestFactory
    {
        /** @var RequestFactory $requestFactory */
        $requestFactory = $this->containerBuilder->get(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\RequestFactory::class);
        return $requestFactory;
    }
    /**
     * @param RequestInterface $request
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function sendRequest(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        /** @var ApiClient $apiClient */
        $apiClient = $this->containerBuilder->get(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient::class);
        return $apiClient->sendRequest($request);
    }
    /**
     * @param ApiContext $apiContext
     * @param array<mixed> $requestDefaults
     * @param string $cacheDir
     * @return ClientInterface
     */
    private function getGuzzleClient(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\ApiContext $apiContext, array $requestDefaults, string $cacheDir) : \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\ClientInterface
    {
        $stack = \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\HandlerStack::create();
        $stack->push(new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheMiddleware($this->buildCacheStrategy($apiContext, $cacheDir)));
        return new \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Client(\array_merge(['handler' => $stack], $requestDefaults));
    }
    /**
     * This function sets the cache strategy used in the application.
     * By default, endpoints will not be cached unless specified per path, per method.
     * We also use two types of cache, ArrayCache, and FileSystem cache sorted from faster to slower.
     * We always use a greedy strategy (ignore headers returned by the server)
     *
     * read more @https://github.com/Kevinrob/guzzle-cache-middleware
     * @param ApiContext $apiContext
     * @param string $cacheDir
     * @return CacheStrategyInterface
     */
    private function buildCacheStrategy(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Config\ApiContext $apiContext, string $cacheDir) : \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface
    {
        return (new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache\CacheStrategyConfigurator(new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache\ApiCacheMap()))->buildCacheStrategy($cacheDir, $apiContext->getApiPath());
    }
    /**
     * This function escapes '%' because Symfony dependency injection uses it to detect the value of the set parameter
     * using the following regex: `%%|%([^%\s]+)%` in the yaml file
     */
    private function escapeSpecialCharacters(string $value) : string
    {
        return \str_replace('%', '%%', $value);
    }
}
