<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Transformer;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SettingsModel;
use TypeError;
use function get_class_methods;
use function substr;
class EmptyModelToNullTransformer implements \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Transformer\Transformer
{
    /**
     * @inheritDoc
     */
    public function canTransform($value) : bool
    {
        return $value instanceof \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model && !$value instanceof \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SettingsModel;
    }
    /**
     * @inheritDoc
     */
    public function transform($value)
    {
        foreach (\get_class_methods($value) as $method) {
            try {
                if (\substr($method, 0, 3) === 'get' && $value->{$method}()) {
                    return $value;
                }
            } catch (\TypeError $typeError) {
                /**
                 * non-nullable field not initiated
                 */
                continue;
            }
        }
        return null;
    }
}
