
{if $errorMessage}
    <div class="errorbox"><strong><span class="title">Error</span></strong><br>{$errorMessage}</div>
{/if}

{if $successMessage}
    <div class="successbox"><strong><span class="title">Success!</span></strong><br>{$successMessage}</div>
{/if}


<nav class="nav">
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=index"><i class="fa fa-clock"></i>Awaiting Approval</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=charged"><i class="fa fa-history"></i>Charged</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=open"><i class="fa fa-user"></i>Open</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=cron"><i class="fa fa-info-circle"></i>Cron info</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=free" class="active"><i class="fa fa-wrench"></i>Free Minutes</a>
</nav>


<div class="panel panel-default">
    <div class="panel-body">
        <button data-toggle="modal" data-target="#addModal" type="button" class='btn btn-primary'>Add</button><br><br>
        <table id="configTable" class="table table-striped table-bordered"
               style="border-collapse:collapse; width:100%;">
            <thead>
            <tr>
                <th>ID</th>
                <th>Product Name</th>
                <th>Prefixes</th>
                <th>Free Minutes Amount</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<div id="addModal" class="modal fade" role="dialog">
    <form method="POST" id="editForm" action="addonmodules.php?module=GiantVoIPResellerBilling&action=addFreeMinutesEntry">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" style="display:inline-block;">Add Entry</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="product">Product</label>
                        <select id="product" class="form-control" name="productId">
                            <option value=""></option>
                            {foreach $products as $product}
                                <option value="{$product.id}">{$product.name}</option>
                            {/foreach}
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="prefixes">Prefixes (Comma Separated)</label>
                        <input type="text" name="prefixes"
                               class="form-control"
                               id="prefixes" aria-describedby="prefixes"
                               placeholder="">
                    </div>
                    <div class="form-group">
                        <label for="freeMinutesAmount">Free Minutes Amount</label>
                        <input required type="text" name="freeMinutesAmount"
                               class="form-control"
                               id="freeMinutesAmount" aria-describedby="freeMinutesAmount"
                               placeholder="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Add</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </form>
</div>

<div id="editModal" class="modal fade" role="dialog">
    <form method="POST" id="editForm" action="addonmodules.php?module=GiantVoIPResellerBilling&action=editFreeMinutesEntry">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" style="display:inline-block;">Edit Entry</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="editGroupIdInput" name="groupId">
                    <div class="form-group">
                        <label for="editProductInput">Product</label>
                        <select id="editProductInput" class="form-control" name="productId">
                            <option value=""></option>
                            {foreach $products as $product}
                                <option value="{$product.id}">{$product.name}</option>
                            {/foreach}
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="editPrefixesInput">Prefixes (Comma Separated)</label>
                        <input type="text" name="prefixes"
                               class="form-control"
                               id="editPrefixesInput" aria-describedby=""
                               placeholder="">
                    </div>
                    <div class="form-group">
                        <label for="editFreeMinutesAmountInput">Free Minutes Amount</label>
                        <input required type="text" name="freeMinutesAmount"
                               class="form-control"
                               id="editFreeMinutesAmountInput" aria-describedby=""
                               placeholder="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </form>
</div>

<div id="removeModal" class="modal fade" role="dialog">
    <form method="POST" id="editForm" action="addonmodules.php?module=GiantVoIPResellerBilling&action=removeFreeMinutesEntry">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" style="display:inline-block;">Remove Entry</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h2>Are you Sure?</h2>
                    <input type="hidden" id="removeGroupIdInput" name="groupId">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Remove</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </form>
</div>

<style>
    .nav {
        padding: 10px;
    }

    .nav a {
        cursor: pointer;
        display: inline-block;
        text-align: center;
        width: 200px;
        padding: 10px;
        color: #337ab7;
        border-radius: 6px;
    }

    .nav a:hover {
        text-decoration: none;
    }

    .nav a i {
        font-size: 1.5rem;
        margin-right: 5px;
    }

    .nav a.active {
        background-color: #337ab7;
        color: white;
    }
</style>

{literal}
    <script>
        $(document).ready(function () {
            $('#configTable').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": "addonmodules.php?module=GiantVoIPResellerBilling&action=getFreeMinutesConfig",
                "searching": true,
                "columnDefs": [
                    {
                        "targets": [4],
                        'searchable': false,
                        'orderable': false,
                        'render': function (data, type, full) {
                            return `
                                <button onclick="editModal('${full["tenantId"]}','${full[2]}','${full[3]}','${full[4]}')" data-toggle="modal" data-target="#editModal" type="button" class='btn btn-primary'><i class='fa fa-edit'></i></button>
                                <button onclick="removeModal('${full["tenantId"]}')" data-toggle="modal" data-target="#removeModal" type="button" class='btn btn-danger'><i class='fa fa-times'></i></button>`
                        }
                    }
                ]
            })
        });

        function removeModal(groupId) {
            $('#removeGroupIdInput').val(groupId);
        }

        function editModal(groupId,prefixes,freeMinutesAmount,productId) {
            $('#editGroupIdInput').val(groupId);
            $('#editPrefixesInput').val(prefixes);
            $('#editFreeMinutesAmountInput').val(freeMinutesAmount);
            $('#editProductInput').val(productId);
        }

    </script>
{/literal}